// Copyright (c) 2000-2025 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_UI_BROWSER_DESKTOP_WINDOW_TREE_HOST_WIN_H_
#define CORE_MAIN_UI_BROWSER_DESKTOP_WINDOW_TREE_HOST_WIN_H_

#include "chrome/browser/ui/views/frame/browser_desktop_window_tree_host_win.h"

namespace platinum {

class BrowserImpl;

class BrowserDesktopWindowTreeHostWin : public ::BrowserDesktopWindowTreeHostWin {
 public:
  BrowserDesktopWindowTreeHostWin(views::internal::NativeWidgetDelegate* native_widget_delegate,
                                  views::DesktopNativeWidgetAura* desktop_native_widget_aura,
                                  BrowserView* browser_view,
                                  BrowserFrame* browser_frame);
  ~BrowserDesktopWindowTreeHostWin() override;

  // Overridden from WindowTreeHost:
  int64_t GetDisplayId() override;
  gfx::Rect GetBoundsInPixels() const override;
  void SetBoundsInPixels(const gfx::Rect& bounds) override;
  void SetRootWindow(gfx::AcceleratedWidget window);
  void SetBoundsInScreen(const gfx::Rect& rect);
  void NotifyDisplayChanged();
  bool IsActive() const override;
  void SetActive(bool is_active);
  void SetBrowser(BrowserImpl* browser);

 private:
  gfx::Rect bounds_in_screen_;
  gfx::AcceleratedWidget root_window_;
  raw_ptr<BrowserImpl> browser_;
  bool is_active_;
};

}  // namespace platinum

#endif  // CORE_MAIN_UI_BROWSER_DESKTOP_WINDOW_TREE_HOST_WIN_H_
