#  Copyright (c) 2000-2025 TeamDev. All rights reserved.
#  TeamDev PROPRIETARY and CONFIDENTIAL.
#  Use is subject to license terms.

from common import *


class Value:
    def __init__(self, value):
        self.value = value


class BoolValue(Value):
    def __init__(self, value):
        Value.__init__(self, "true" if value else "false")


class StringValue(Value):
    def __init__(self, value):
        Value.__init__(self, '"' + value + '"')


class ProjectConfig:
    def __init__(self):
        self.project_args = {}
        self.params = []
        pass

    def is_component_build(self, value):
        self.project_args["is_component_build"] = BoolValue(value)

    def chrome_pgo_phase(self, value):
        self.project_args["chrome_pgo_phase"] = Value(str(value))

    def treat_warnings_as_errors(self, value):
        self.project_args["treat_warnings_as_errors"] = BoolValue(value)

    def enable_precompiled_headers(self, value):
        self.project_args["enable_precompiled_headers"] = BoolValue(value)

    def target_cpu(self, value):
        self.project_args["target_cpu"] = StringValue(value)

    def is_mac_os_native_chrome_icon_hidden(self, value):
        self.project_args["is_mac_os_native_chrome_icon_hidden"] = BoolValue(value)

    def enable_proprietary_features(self):
        self.project_args["ffmpeg_branding"] = StringValue("Chrome")
        self.project_args["proprietary_codecs"] = BoolValue(True)
        self.project_args["enable_widevine"] = BoolValue(True)
        self.project_args["enable_mse_mpeg2ts_stream_parser"] = BoolValue(True)
        self.project_args["enable_library_cdms"] = BoolValue(True)

        # Chrome 98 doesn't support signing of binaries with Widevine signature. If we pass the
        # following build argument on Linux, the Chromium compilation will fail.
        if is_windows() or is_mac():
            self.project_args["enable_cdm_host_verification"] = BoolValue(True)

    def symbol_level(self, value):
        self.project_args["symbol_level"] = Value(str(value))

    def blink_symbol_level(self, value):
        self.project_args["blink_symbol_level"] = Value(str(value))

    def v8_symbol_level(self, value):
        self.project_args["v8_symbol_level"] = Value(str(value))

    def is_cfi(self, value):
        self.project_args["is_cfi"] = BoolValue(value)

    def use_thin_lto(self, value):
        self.project_args["use_thin_lto"] = BoolValue(value)

    def use_qt5(self, value):
        self.project_args["use_qt5"] = BoolValue(value)

    def use_qt6(self, value):
        self.project_args["use_qt6"] = BoolValue(value)

    def disable_fieldtrial_testing_config(self, value):
        self.project_args["disable_fieldtrial_testing_config"] = BoolValue(value)

    def is_official_build(self, value):
        self.project_args["is_official_build"] = BoolValue(value)

    def enable_license_checker(self, value):
        self.project_args["enable_license_checker"] = BoolValue(value)

    def allow_chromium_app_startup(self, value):
        self.project_args["allow_chromium_app_startup"] = BoolValue(value)

    def platinum_mas_build(self, value):
        self.project_args["platinum_mas_build"] = BoolValue(value)

    def build_jni_libraries(self, value):
        self.project_args["build_jni_libraries"] = BoolValue(value)

    def is_debug(self, value):
        self.project_args["is_debug"] = BoolValue(value)

    def dcheck_always_on(self, value):
        self.project_args["dcheck_always_on"] = BoolValue(value)

    def ozone_platform(self, value):
        self.project_args["ozone_platform"] = StringValue(value)

    def ozone_platform_wayland(self, value):
        self.project_args["ozone_platform_wayland"] = BoolValue(value)

    def ozone_platform_x11(self, value):
        self.project_args["ozone_platform_x11"] = BoolValue(value)

    def use_xkbcommon(self, value):
        self.project_args["use_xkbcommon"] = BoolValue(value)

    def forbid_non_component_debug_builds(self, value):
        self.project_args["forbid_non_component_debug_builds"] = BoolValue(value)

    def use_compiler_cache(self, value):
        if value:
            if is_windows():
                self.project_args["cc_wrapper"] = StringValue("sccache")
            if is_mac() or is_linux():
                self.project_args["cc_wrapper"] = StringValue("ccache")

    def use_siso(self, value):
        self.project_args["use_siso"] = BoolValue(value)

    def generate_vs_project(self):
        self.params += ["--ide=vs2022",
                        "--filters=//browsercore:*;//chrome",
                        "--no-deps",
                        "--sln=platinum"]

    def generate_qt_project(self):
        self.params += ["--ide=qtcreator"]

    def build(self):
        args = ["--args="]
        for key in self.project_args:
            args[0] += key + "=" + self.project_args[key].value + " "
        for param in self.params:
            args.append(param)
        return args

    def __str__(self):
        args = []
        for key in self.project_args:
            args.append(key + " = " + self.project_args[key].value)
        for param in self.params:
            args.append(param)
        return "\n".join(args)
