// Copyright (c) 2000-2025 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_WEB_DIALOG_NATIVE_WIDGET_FACTORY_H_
#define CORE_MAIN_WEB_DIALOG_NATIVE_WIDGET_FACTORY_H_

#include <cstdint>
#include <memory>

namespace views {
class NativeWidgetMacNSWindowHost;
class NativeWidgetMac;

}  // namespace views

namespace remote_cocoa {
class NativeWidgetNSWindowBridge;
class NativeWidgetNSWindowHostHelper;

namespace mojom {
class NativeWidgetNSWindowHost;
class TextInputHost;

}  // namespace mojom

}  // namespace remote_cocoa

namespace platinum {

class NativeWidgetFactory {
 public:
  static std::unique_ptr<remote_cocoa::NativeWidgetNSWindowBridge> CreateNativeWidgetNSWindowBridge(
      uint64_t bridged_native_widget_id,
      remote_cocoa::mojom::NativeWidgetNSWindowHost* host,
      remote_cocoa::NativeWidgetNSWindowHostHelper* host_helper,
      remote_cocoa::mojom::TextInputHost* text_input_host);
};

}  // namespace platinum

#endif  // CORE_MAIN_WEB_DIALOG_NATIVE_WIDGET_FACTORY_H_
