// Copyright (c) 2000-2025 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_COMMON_BROWSERCORE_SWITCHES_H_
#define CORE_COMMON_BROWSERCORE_SWITCHES_H_

namespace switches {
// Enables the Platinum functionality.
extern const char kBrowserCore[];
// Indicates that Chromium represents a hybrid desktop app.
extern const char kPlatinumApp[];
// The socket connection port.
extern const char kPort[];
// The list of the enabled proprietary features. This is an internal switch that
// is passed to the child processes. The client configures this via EngineOptions.
extern const char kProprietaryFeatures[];
// Specifies the dpi-awareness for this process. The acceptable values are "unaware",
// "system-aware", and "per-monitor-aware". Windows only.
extern const char kDpiAwareness[];
// Enables the off-screen rendering mode.
extern const char kOffscreen[];
// Enables the console window that shows logs printed from the gpu process
// to the standard output. Windows only.
extern const char kEnableGpuLogging[];
// Shows a debug dialog on the browser process startup.
extern const char kBrowserCoreStartupDialog[];
// The engine id. This is an internal switch that is passed to the child processes.
extern const char kEngineId[];
// Enables a possibility to send the name of COM object associated with drag data (if available).
extern const char kEnableComDragDrop[];
// Enables a possibility to display the custom dropdown list to show HTML select popup menu
extern const char kEnableCustomDropdowns[];
// A comma-separated list of the URL schemes that defines which URL requests should be intercepted.
extern const char kSchemes[];
// Disables requesting system printers and their capabilities when configuring
// print settings programmatically.
extern const char kUsePdfPrinterOnly[];
// Disables processing of the on-screen requests using the client. By default these requests
// processed by custom Platinum implementation. Setting of this parameter forces usage
// the Chromium engine implementation.
extern const char kUseLegacyOsk[];
// Disables DNS Quick Check in proxy resolution.
extern const char kDisableQuickDnsCheck[];
// Enables support of the `--remote-debugging-port` Chromium switch in the production mode.
extern const char kEnableRemoteDebuggingPort[];
// Enables the warning on quitting the application via Cmd+Q. Only on Mac.
extern const char kWarnBeforeQuitting[];
// Enables the Chromium's AmbientAuthenticationInPrivateModesEnabled policy.
// By default, it's disabled.
// See https://chromeenterprise.google/policies/#AmbientAuthenticationInPrivateModesEnabled
extern const char kEnableAmbientAuthenticationInPrivateModes[];
// Disables Chromium crash reporter on Mac. This switch is used in the Platinum App mode -
// MoBrowser. The crash reporter must be disabled when a MoBrowser based app is submitted to the
// Apple App Store. All crash dumps will be collected by Apple.
extern const char kDisableCrashReporter[];
// Enables automatic VoiceOver narration of all the web page's content when the page is loaded.
extern const char kEnableVoiceOverReadAll[];
// This switch means that all keyboard events and mouse events (Windows only) should be
// pre-processed on the native side. This switch is typically used when the input is collected
// by the native runtime environment rather than by the native Java/.Net API.
// IMPORTANT: mouse events are collected by the native runtime environment only on Windows.
extern const char kUseClientNativeInput[];
// This switch means that Chromium is launched in touch environment. In touch environment certain
// browsercore patches must be disabled for correct on-screen keyboard functioning on Linux.
extern const char kTouchEnvironment[];
// On Chromium window sizing, we might receive too many resize requests to be rendered.
// To provide a smoother and more responsive behavior during resize, we filter and defer the
// update requests:
//  - By default, the browser widget resizes are made only when the previous request
//    has been fully applied and the content has been rendered with the requested size.
//    That allows utilizing the GPU more actively to provide smoother Chromium-like resize.
//  - This switch makes the requests to be applied no more frequently than
//    each 50ms on window sizing. It is legacy mode, though might be useful when
//    the client window embeds untypically many browser views (20+),
//    especially on the low-end hardware.
extern const char kLimitResizeFrequency[];
// Disables DNS over HTTPS (DoH) protocol for DNS resolution. When disabled Chromium will use
// unencrypted system DNS over UDP or TCP as configured by the operating system.
extern const char kDisableDnsOverHttps[];
// Overrides the time zone from the operating system host with the given one.
extern const char kTimeZone[];
}  // namespace switches

#endif  // CORE_COMMON_BROWSERCORE_SWITCHES_H_
