#  Copyright (c) 2000-2026 TeamDev. All rights reserved.
#  TeamDev PROPRIETARY and CONFIDENTIAL.
#  Use is subject to license terms.

import argparse

from common import *


def get_binaries_fileset_linux():
    return [
        "locales",
        "icudtl.dat",
        "libEGL.so",
        "libGLESv2.so",
        "resources.pak",
        "v8_context_snapshot.bin",
        "chrome_crashpad_handler",
        "chrome_100_percent.pak",
        "chrome_200_percent.pak",
        "chromium",
        "libipc.so",
        "libtoolkit.so",
        "libawt_toolkit.so",
        "libvk_swiftshader.so",
        "libvulkan.so.1",
        "vk_swiftshader_icd.json"
    ]


def get_binaries_fileset_mac():
    return [
        "Chromium.app",
    ]


def get_x86_64_libs_win():
    return [
        "ipc32.dll",
        "ipc64.dll",
        "toolkit32.dll",
        "toolkit64.dll",
        "awt_toolkit32.dll",
        "awt_toolkit64.dll"
    ]


def get_arm_libs_win():
    return [
        "ipc_arm64.dll",
        "toolkit_arm64.dll",
        "awt_toolkit_arm64.dll"
    ]


def get_binaries_fileset_win():
    chromium_binaries = [
        "locales",
        "MEIPreload",
        "icudtl.dat",
        "libEGL.dll",
        "libGLESv2.dll",
        "d3dcompiler_47.dll",
        "dxcompiler.dll",
        "dxil.dll",
        "resources.pak",
        "v8_context_snapshot.bin",
        "chrome_100_percent.pak",
        "chrome_200_percent.pak",
        "vk_swiftshader.dll",
        "vk_swiftshader_icd.json",
        "vulkan-1.dll",

        "chrome.dll",
        "chrome.dll.sig",
        "chromium.exe",
        "chromium.exe.sig",
        "chrome_elf.dll",
        "{}.manifest".format(chromium_version)
    ]
    return chromium_binaries + get_x86_64_libs_win() + get_arm_libs_win()


def get_binaries_fileset():
    if is_windows():
        return get_binaries_fileset_win()
    if is_linux():
        return get_binaries_fileset_linux()
    if is_mac():
        return get_binaries_fileset_mac()
    sys.exit("Unsupported operating system: " + platform.system())


def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("--chromium_src_dir", type=str, metavar="", default=get_default_chromium_src_dir(),
                        help="The absolute path to the Chromium src directory.")
    parser.add_argument("--out_dir_name", type=str, metavar="", default="out/Release",
                        help="The build output directory.")
    parser.add_argument("--target_dir", type=str, default="target/bin",
                        help="The path to which the binaries will be copied.")

    args = parser.parse_args()

    if is_chromium_src_dir(args.chromium_src_dir):
        out_dir_path = os.path.join(args.chromium_src_dir, args.out_dir_name)
        target_dir = os.path.normpath(os.path.join(get_project_root(), args.target_dir))
        copy_files(out_dir_path, target_dir, get_binaries_fileset())
    else:
        parser.print_help()


if __name__ == "__main__":
    main()
