// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_COMMON_PROPRIETARY_FEATURES_H_
#define CORE_COMMON_PROPRIETARY_FEATURES_H_

#include "base/no_destructor.h"
#include "media/base/media_types.h"

class Browser;

namespace platinum {

class ProprietaryFeaturesDelegate {
 public:
  virtual ~ProprietaryFeaturesDelegate() = default;
  virtual bool IsAudioCodecEnabled(::media::AudioType type) const = 0;
  virtual bool IsVideoCodecEnabled(::media::VideoType type) const = 0;
};

class ProprietaryFeatures : public ProprietaryFeaturesDelegate {
 public:
  ProprietaryFeatures(const ProprietaryFeatures&) = delete;
  ProprietaryFeatures& operator=(const ProprietaryFeatures&) = delete;

  static ProprietaryFeatures& Get();

  bool IsAudioCodecEnabled(::media::AudioType type) const override;
  bool IsVideoCodecEnabled(::media::VideoType type) const override;

 private:
  uint32_t feature_flags_;

  ProprietaryFeatures();
  ~ProprietaryFeatures() override;

  friend class base::NoDestructor<ProprietaryFeatures>;
};

}  // namespace platinum

#endif  // CORE_COMMON_PROPRIETARY_FEATURES_H_
