// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef INCLUDE_PLATINUM_NETWORK_FACTORY_H_
#define INCLUDE_PLATINUM_NETWORK_FACTORY_H_

#include "base/memory/weak_ptr.h"
#include "base/time/time.h"

namespace network {
class NetworkContext;
class NetworkService;
}  // namespace network

namespace net {
class URLRequestJobFactory;
}

class PlatinumNetworkFactory {
 public:
  template <class OnConnectionCloseCallback, class NetworkContextParamsPtr, class PendingReceiver>
  static std::unique_ptr<network::NetworkContext> CreateNetworkContext(
      network::NetworkService* network_service,
      PendingReceiver receiver,
      NetworkContextParamsPtr params,
      OnConnectionCloseCallback on_connection_close_callback = OnConnectionCloseCallback());

  static std::unique_ptr<net::URLRequestJobFactory> CreateURLRequestJobFactory();
};

#endif  // INCLUDE_PLATINUM_NETWORK_FACTORY_H_
