// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef INCLUDE_PLATINUM_RENDERER_FACTORY_H_
#define INCLUDE_PLATINUM_RENDERER_FACTORY_H_

#include "chrome/renderer/printing/chrome_print_render_frame_helper_delegate.h"
#include "components/pdf/renderer/pdf_view_web_plugin_client.h"
#include "components/spellcheck/renderer/spellcheck.h"
#include "components/spellcheck/renderer/spellcheck_provider.h"

class ChromePDFPrintClient;

namespace platinum {

class PlatinumRendererFactory {
 public:
  static std::unique_ptr<pdf::PdfViewWebPluginClient> CreatePdfViewWebPluginClient(
      content::RenderFrame* frame);
  static ::SpellCheckProvider* CreateSpellCheckProvider(content::RenderFrame* render_frame,
                                                        SpellCheck* spellcheck);
  static std::unique_ptr<ChromePrintRenderFrameHelperDelegate>
  CreatePrintRenderFrameHelperDelegate();

  static std::unique_ptr<::SpellCheck> CreateSpellCheck(
      service_manager::LocalInterfaceProvider* embedder_provider);
};

}  // namespace platinum

#endif  // INCLUDE_PLATINUM_RENDERER_FACTORY_H_
