// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_UI_BROWSER_DESKTOP_WINDOW_TREE_HOST_LINUX_H_
#define CORE_MAIN_UI_BROWSER_DESKTOP_WINDOW_TREE_HOST_LINUX_H_

#include "chrome/browser/ui/views/frame/browser_desktop_window_tree_host_linux.h"

namespace platinum {

class BrowserDesktopWindowTreeHostLinux : public ::BrowserDesktopWindowTreeHostLinux {
 public:
  BrowserDesktopWindowTreeHostLinux(views::internal::NativeWidgetDelegate* native_widget_delegate,
                                    views::DesktopNativeWidgetAura* desktop_native_widget_aura,
                                    ::BrowserView* browser_view,
                                    BrowserWidget* browser_widget);
  ~BrowserDesktopWindowTreeHostLinux() override;

  void SetBoundsInScreen(const gfx::Rect& rect);

  // Converts bounds from the platform_window() to the absolute screen coordinates.
  gfx::Point GetLocationOnScreenInPixels() const override;

  void OnCloseRequest() override;

  void ChangeActivation(bool active);

 private:
  gfx::Rect last_bounds_in_screen_;
};

}  // namespace platinum

#endif  // CORE_MAIN_UI_BROWSER_DESKTOP_WINDOW_TREE_HOST_LINUX_H_
