/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.DefaultCallbacks;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.platform.win.MessageLoopHelper;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.view.swt.DragAndDrop;
import com.teamdev.jxbrowser.view.swt.callback.DefaultAlertCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultBeforeFormRepostCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultBeforeUnloadCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultConfirmCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultOpenExternalAppCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultOpenFileCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultOpenFilesCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultOpenFolderCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultOpenPopupCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultPrintCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultPromptCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultSaveAsPdfCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultSelectClientCertificateCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultSelectColorCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultShowContextMenuCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultStartCaptureSessionCallback;
import com.teamdev.jxbrowser.view.swt.callback.DefaultStartDownloadCallback;
import com.teamdev.jxbrowser.view.swt.callback.internal.DefaultShowSuggestionsCallback;
import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.menu.SuggestionsListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class BrowserView
extends Composite {
    private final Browser browser;
    private final DragAndDrop dragAndDrop;
    private final DefaultCallbacks<BrowserCallback> defaultCallbacks;
    private BrowserComposite browserComposite;
    private Subscription onBrowserClosed;
    private int width;
    private int height;

    public static BrowserView newInstance(Composite parent, Browser browser) {
        return new BrowserView(parent, browser);
    }

    private BrowserView(Composite parent, Browser browser) {
        super(parent, 0);
        Logger.debug((String)"UI Toolkit: SWT");
        Preconditions.checkNotNull((Object)browser);
        this.browser = browser;
        this.defaultCallbacks = this.defaultCallbacks();
        SuggestionsListener suggestionsListener = new SuggestionsListener(browser);
        if (browser instanceof BrowserImpl) {
            if (MessageLoopHelper.isSupported((RenderingMode)browser.engine().options().renderingMode())) {
                MessageLoopHelper.markAsMessageLoopThread();
            }
            this.setLayout((Layout)new FillLayout());
            BrowserWidget widget = this.widget();
            this.browserComposite = BrowserComposite.create(this, widget);
            this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
                SafeExecutor.asyncExec((Widget)this, () -> ((BrowserComposite)this.browserComposite).dispose());
                this.defaultCallbacks.unregister();
                suggestionsListener.stopEventsProcessing();
                this.onBrowserClosed.unsubscribe();
            });
        }
        this.dragAndDrop = new DragAndDropSupport();
        suggestionsListener.startEventsProcessing();
        this.defaultCallbacks.register();
    }

    private BrowserWidget widget() {
        return ((BrowserImpl)this.browser).widget();
    }

    private DefaultCallbacks<BrowserCallback> defaultCallbacks() {
        return DefaultCallbacks.of((Advisable)this.browser).add((Callback)((CreatePopupCallback)params -> CreatePopupCallback.Response.create())).add((Callback)new DefaultAlertCallback(this)).add((Callback)new DefaultBeforeFormRepostCallback(this)).add((Callback)new DefaultBeforeUnloadCallback(this)).add((Callback)new DefaultConfirmCallback(this)).add((Callback)new DefaultOpenFileCallback(this)).add((Callback)new DefaultOpenFilesCallback(this)).add((Callback)new DefaultOpenFolderCallback(this)).add((Callback)new DefaultOpenPopupCallback(this)).add((Callback)new DefaultPrintCallback()).add((Callback)new DefaultPromptCallback(this)).add((Callback)new DefaultSaveAsPdfCallback(this)).add((Callback)new DefaultSelectClientCertificateCallback(this)).add((Callback)new DefaultSelectColorCallback(this)).add((Callback)new DefaultShowContextMenuCallback(this)).add((Callback)new DefaultStartDownloadCallback(this)).add((Callback)new DefaultStartCaptureSessionCallback()).add((Callback)new DefaultOpenExternalAppCallback(this)).add((Callback)new DefaultShowSuggestionsCallback(this)).build();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return new Point(this.width, this.height);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.width = width;
        this.height = height;
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.browserComposite.setVisible(visible);
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop;
    }

    private class DragAndDropSupport
    implements DragAndDrop {
        private DragAndDropSupport() {
        }

        @Override
        public void enable() {
            if (BrowserView.this.browser instanceof BrowserImpl) {
                ((BrowserImpl)BrowserView.this.browser).dragAndDrop().enable();
            }
            if (BrowserView.this.browserComposite != null) {
                BrowserView.this.browserComposite.enableDragAndDrop();
            }
        }

        @Override
        public void disable() {
            if (BrowserView.this.browserComposite != null) {
                BrowserView.this.browserComposite.disableDragAndDrop();
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                ((BrowserImpl)BrowserView.this.browser).dragAndDrop().disable();
            }
        }

        @Override
        public boolean isEnabled() {
            if (BrowserView.this.browser instanceof BrowserImpl) {
                return ((BrowserImpl)BrowserView.this.browser).dragAndDrop().isEnabled();
            }
            return false;
        }
    }
}

