/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.callback;

import com.teamdev.jxbrowser.browser.callback.SelectClientCertificateCallback;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.net.tls.X509Certificates;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.dialog.SelectDialog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Widget;

public final class DefaultSelectClientCertificateCallback
extends DefaultCallback
implements SelectClientCertificateCallback {
    public DefaultSelectClientCertificateCallback(BrowserView parent) {
        super(parent);
    }

    public void on(SelectClientCertificateCallback.Params params, SelectClientCertificateCallback.Action tell) {
        List certificates = params.certificates();
        if (certificates.isEmpty()) {
            tell.cancel();
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        try {
            for (Certificate certificate : certificates) {
                ByteArrayInputStream stream = new ByteArrayInputStream(certificate.derEncodedValue());
                items.add(X509Certificates.of((InputStream)stream).getSubjectDN().getName());
            }
        }
        catch (CertificateException e) {
            Logger.error((String)"Failed to parse an X509Certificate.", (Throwable)e);
            tell.cancel();
            return;
        }
        SafeExecutor.asyncExec((Widget)this.widget(), () -> {
            SelectDialog dialog = (SelectDialog)((SelectDialog.Builder)((SelectDialog.Builder)((SelectDialog.Builder)((SelectDialog.Builder)SelectDialog.newBuilder(((BrowserView)((Object)((Object)this.widget()))).getShell(), params.message()).title(params.title())).addAllItems(items).addButton(params.selectActionText(), d -> {
                int selectedIndex = d.selectedIndex();
                if (selectedIndex != -1) {
                    tell.select(selectedIndex);
                }
            })).addButton(params.cancelActionText(), () -> ((SelectClientCertificateCallback.Action)tell).cancel())).defaultAction(() -> ((SelectClientCertificateCallback.Action)tell).cancel())).build();
            dialog.open();
        }, () -> ((SelectClientCertificateCallback.Action)tell).cancel());
    }
}

