/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.BuiltInCursors;
import com.teamdev.jxbrowser.ui.internal.CursorFactory;
import com.teamdev.jxbrowser.view.swt.graphics.BitmapImage;
import com.teamdev.jxbrowser.view.swt.internal.BuiltInCursors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

@ParametersAreNonnullByDefault
final class SwtCursorFactory
extends CursorFactory<Cursor, Integer> {
    private final Device device;

    private SwtCursorFactory(Device device) {
        super(BuiltInCursors.instance());
        this.device = device;
    }

    static SwtCursorFactory forDevice(Device device) {
        Preconditions.checkNotNull((Object)device);
        return new SwtCursorFactory(device);
    }

    protected Cursor toolkitCursor(Integer cursorStyle) {
        return new Cursor(this.device, cursorStyle.intValue());
    }

    protected Cursor builtInCursor(BuiltInCursors.BuiltInCursorData data) {
        ImageData imageData = new ImageData(data.resourceAsStream());
        Point hotspot = data.hotspot();
        return new Cursor(this.device, imageData, hotspot.x(), hotspot.y());
    }

    protected Cursor customCursor(Bitmap bitmap, Point hotspot) {
        Image cursorImage = BitmapImage.toToolkit(this.device, bitmap);
        return new Cursor(this.device, cursorImage.getImageData(), hotspot.x(), hotspot.y());
    }

    protected Cursor defaultCursor() {
        return this.toolkitCursor(0);
    }
}

