/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DragOperations;
import com.teamdev.jxbrowser.view.swt.internal.dnd.SupportedDataTypes;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

final class DropTargetListener
implements org.eclipse.swt.dnd.DropTargetListener {
    private final BrowserWidget widget;
    private final BrowserDragContext context;
    private final OffScreenRenderWidget composite;

    static DropTargetListener newInstance(OffScreenRenderWidget composite, BrowserDragContext context) {
        Preconditions.checkNotNull((Object)composite);
        return new DropTargetListener(composite, context);
    }

    private DropTargetListener(OffScreenRenderWidget composite, BrowserDragContext context) {
        this.widget = composite.browserWidget();
        this.composite = composite;
        this.context = context;
    }

    public void drop(DropTargetEvent event) {
        Point screenPoint = Point.of((int)event.x, (int)event.y);
        Point localPoint = this.screenToLocal(event.x, event.y);
        if (Environment.isLinux() && this.context.browserDragOperation().isPresent()) {
            BrowserDragContext.CurrentDragOperation operation = this.context.browserDragOperation().get();
            this.performDrop(operation.dropData(), localPoint, screenPoint);
        } else {
            DropData.Builder dropData = DropData.newBuilder();
            for (TransferData transferData : event.dataTypes) {
                SupportedDataTypes.supportedTypes().forEach(dataType -> dataType.fillDropData(transferData, dropData));
            }
            this.performDrop(dropData.build(), localPoint, screenPoint);
        }
        event.detail = 1;
    }

    public void dragEnter(DropTargetEvent event) {
        DropMetadata.Builder metadata = DropMetadata.newBuilder();
        for (TransferData transferData : event.dataTypes) {
            SupportedDataTypes.supportedTypes().forEach(dataType -> dataType.fillMetadata(transferData, metadata));
        }
        int operationsAllowed = DragOperations.toDragOperationMask(event.detail);
        Point localPoint = this.screenToLocal(event.x, event.y);
        Point screenPoint = Point.of((int)event.x, (int)event.y);
        this.widget.dragEnter(metadata.build(), localPoint, screenPoint, operationsAllowed);
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.isCursorOutsideComposite()) {
            this.widget.dragLeave();
        }
    }

    public void dragOver(DropTargetEvent event) {
        int operationsAllowed = DragOperations.toDragOperationMask(event.detail);
        Point localPoint = this.screenToLocal(event.x, event.y);
        Point screenPoint = Point.of((int)event.x, (int)event.y);
        this.widget.dragOver(localPoint, screenPoint, operationsAllowed);
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private void performDrop(DropData dropData, Point localPoint, Point screenPoint) {
        this.widget.drop(dropData, localPoint, screenPoint);
    }

    private Point screenToLocal(int screenX, int screenY) {
        org.eclipse.swt.graphics.Point locationOnScreen = this.composite.toDisplay(0, 0);
        int localX = screenX - locationOnScreen.x;
        int localY = screenY - locationOnScreen.y;
        Point point = Point.of((int)localX, (int)localY);
        return point;
    }

    private boolean isCursorOutsideComposite() {
        org.eclipse.swt.graphics.Point cursorLocation = Display.getCurrent().getCursorLocation();
        org.eclipse.swt.graphics.Point relativeCursorLocation = this.composite.toControl(cursorLocation);
        boolean moreNorthWestern = relativeCursorLocation.x < 0 || relativeCursorLocation.y < 0;
        boolean moreSouthEastern = relativeCursorLocation.x > this.composite.getSize().x || relativeCursorLocation.y > this.composite.getSize().y;
        return moreNorthWestern || moreSouthEastern;
    }
}

