/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.view.swt.internal.dnd.CustomDataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.EmptyDataTransfer;
import com.teamdev.jxbrowser.view.swt.internal.dnd.EmptyDataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.FileListDataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.HtmlDataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.TextDataType;
import com.teamdev.jxbrowser.view.swt.internal.dnd.UrlDataType;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.swt.dnd.Transfer;

final class SupportedDataTypes {
    private static final List<DataType<?, ?>> dataTypes = ImmutableList.of((Object)new EmptyDataType(), (Object)new CustomDataType(), (Object)new TextDataType(), (Object)new FileListDataType(), (Object)new HtmlDataType(), (Object)new UrlDataType());

    private SupportedDataTypes() {
    }

    static List<DataType<? extends Transfer, ?>> supportedTypes() {
        return dataTypes;
    }

    static Transfer[] supportedTransfers() {
        return SupportedDataTypes.asTransfers(dataType -> true);
    }

    static Transfer[] findTransfers(DropData dropData) {
        Transfer[] transfers = SupportedDataTypes.asTransfers(dataType -> dataType.isPresentedIn(dropData));
        if (transfers.length != 0) {
            return transfers;
        }
        return new Transfer[]{EmptyDataTransfer.getInstance()};
    }

    private static Transfer[] asTransfers(Predicate<DataType<?, ?>> filter) {
        return (Transfer[])dataTypes.stream().filter(filter).map(DataType::transfer).toArray(Transfer[]::new);
    }
}

