/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.platform;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.platform.Hwnd;
import com.teamdev.jxbrowser.view.swt.internal.platform.NsViewId;
import com.teamdev.jxbrowser.view.swt.internal.platform.WindowIdAlgorithm;
import com.teamdev.jxbrowser.view.swt.internal.platform.XWindowId;
import org.eclipse.swt.widgets.Control;

public final class NativeWindow {
    private final WindowIdAlgorithm algorithm;

    public static long handle(Control control) {
        Preconditions.checkNotNull((Object)control);
        return Singleton.instance().findWindowId(control);
    }

    private NativeWindow(WindowIdAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    private long findWindowId(Control control) {
        return this.algorithm.findWindowId(control);
    }

    private static WindowIdAlgorithm algorithm() {
        if (Environment.isMac()) {
            return new NsViewId();
        }
        if (Environment.isWindows()) {
            return new Hwnd();
        }
        if (Environment.isLinux()) {
            return new XWindowId();
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    static /* synthetic */ WindowIdAlgorithm access$100() {
        return NativeWindow.algorithm();
    }

    private static enum Singleton {
        INSTANCE;

        private final NativeWindow value = new NativeWindow(NativeWindow.access$100());

        private static NativeWindow instance() {
            return Singleton.INSTANCE.value;
        }
    }
}

