/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.Status;
import com.teamdev.jxbrowser.internal.rpc.StreamData;
import com.teamdev.jxbrowser.internal.rpc.TextFormat;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamChannel;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Stream
extends CloseableImpl {
    private final Message targetId;
    private final StreamChannel channel;
    private final Service service;
    private final Descriptors.MethodDescriptor method;
    private final AtomicReference<Interceptor> interceptorRef;
    private final Connection connection;

    protected Stream(Service service, Descriptors.MethodDescriptor method, Message targetId, Connection connection) {
        this.service = service;
        this.method = method;
        this.targetId = targetId;
        this.channel = connection.openChannel(service.descriptorForType().getFullName(), method.getName(), new StreamObserver());
        this.connection = connection;
        this.interceptorRef = new AtomicReference();
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptorRef.set(interceptor);
    }

    void resetInterceptor() {
        this.interceptorRef.set(null);
    }

    protected void write(StreamData data) {
        this.logClientRequest(data);
        this.channel.write(data);
    }

    Message targetId() {
        return this.targetId;
    }

    protected Service service() {
        return this.service;
    }

    protected Descriptors.MethodDescriptor method() {
        return this.method;
    }

    protected void openStream() {
        this.write(StreamData.newBuilder().setStatus(Status.OK).setOpenStream(Empty.newBuilder().build()).build());
    }

    protected void subscribe() {
        this.write(this.createSubscriptionRequest(Subscription.SUBSCRIBE));
    }

    protected void unsubscribe() {
        this.write(this.createSubscriptionRequest(Subscription.UNSUBSCRIBE));
    }

    protected abstract StreamData createSubscriptionRequest(Subscription var1);

    protected abstract void process(StreamData var1);

    protected Optional<Interceptor> interceptor() {
        return Optional.ofNullable(this.interceptorRef.get());
    }

    private void logClientRequest(StreamData data) {
        if (Logger.isDebugEnabled()) {
            try {
                Message message = this.service.requestPrototype(this.method).newBuilderForType().mergeFrom(data.getMessage().getBytes()).build();
                long threadId = Thread.currentThread().getId();
                Logger.debug("> [{0}:{1}]: {2}.{3} [ stream_data [ stage_case: {4} status: {5} request: [ id: {6} data [ {7} ]]", this.channel.id(), threadId, this.service.descriptorForType().getFullName(), this.method.getName(), data.getStageCase(), data.getStatus(), data.getMessage().getId(), this.convertRequestToString(message));
            }
            catch (InvalidProtocolBufferException e) {
                Logger.debug("Failed to log a streaming request: {0}, {1}", this.service.descriptorForType().getFullName(), this.method.getName());
            }
        }
    }

    protected String convertRequestToString(Message message) {
        return TextFormat.shortDebugString(message);
    }

    private void logServerResponse(StreamData data) {
        if (Logger.isDebugEnabled()) {
            try {
                Message message = this.service.responsePrototype(this.method).newBuilderForType().mergeFrom(data.getMessage().getBytes()).build();
                long threadId = Thread.currentThread().getId();
                Logger.debug("< [{0}:{1}]: {2}.{3} [ stream_data [ stage_case: {4} status: {5} request: [ id: {6} data [ {7} ]]", this.channel.id(), threadId, this.service.descriptorForType().getFullName(), this.method.getName(), data.getStageCase(), data.getStatus(), data.getMessage().getId(), TextFormat.shortDebugString(message));
            }
            catch (InvalidProtocolBufferException e) {
                Logger.debug("Failed to log a streaming response: {0}, {1}", this.service.descriptorForType().getFullName(), this.method.getName());
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.channel.close();
    }

    private class StreamObserver
    implements RpcCallback<StreamData> {
        private StreamObserver() {
        }

        @Override
        public void onNext(StreamData data) {
            if (data.getStageCase().equals(StreamData.StageCase.MESSAGE)) {
                Stream.this.connection.rpcThread().submit(() -> {
                    Stream.this.logServerResponse(data);
                    Stream.this.process(data);
                });
            }
        }
    }

    static enum Subscription {
        SUBSCRIBE,
        UNSUBSCRIBE;

    }
}

