/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.net.Host;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.CertVerificationStatusList;
import com.teamdev.jxbrowser.net.internal.rpc.VerifyCertificate;
import com.teamdev.jxbrowser.net.tls.CertVerificationStatus;
import com.teamdev.jxbrowser.net.tls.Certificate;
import java.util.List;
import java.util.stream.Collectors;

public interface VerifyCertificateCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response valid() {
            return VerifyCertificate.Response.newBuilder().setValid(Protobuf.empty()).build();
        }

        public static Response invalid(CertVerificationStatus ... verificationStatuses) {
            Preconditions.checkNotNull(verificationStatuses);
            CertVerificationStatusList statusList = CertVerificationStatusList.newBuilder().addAllVerificationStatus(ImmutableList.copyOf(verificationStatuses)).build();
            return VerifyCertificate.Response.newBuilder().setInvalid(statusList).build();
        }

        public static Response defaultAction() {
            return VerifyCertificate.Response.newBuilder().setDefault(Protobuf.empty()).build();
        }
    }

    public static interface Params {
        default public Host host() {
            return ((VerifyCertificate.Request)this).getHost();
        }

        default public Certificate certificate() {
            return ((VerifyCertificate.Request)this).getCertificate();
        }

        default public List<Certificate> intermediateCertificates() {
            return ((VerifyCertificate.Request)this).getIntermediateCertificatesList().stream().map(certificate -> certificate).collect(Collectors.toList());
        }

        default public List<CertVerificationStatus> verificationStatuses() {
            return ((VerifyCertificate.Request)this).getVerificationStatusList();
        }
    }
}

