/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.profile.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.ProfilePreferences;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfilePreferencesStub;
import com.teamdev.jxbrowser.profile.internal.rpc.SetAutofillEnabledRequest;

final class ProfilePreferencesImpl
extends CloseableImpl
implements ProfilePreferences {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<ProfilePreferencesStub> rpc;

    ProfilePreferencesImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.rpc = new ServiceConnectionImpl<ProfilePreferencesStub>(profile.id(), profile.engine().connection(), ProfilePreferencesStub::new);
    }

    @Override
    public boolean isAutofillEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAutofillEnabled, this.profile.id())).getValue();
    }

    @Override
    public void enableAutofill() {
        this.setAutofillEnabled(true);
    }

    @Override
    public void disableAutofill() {
        this.setAutofillEnabled(false);
    }

    private void setAutofillEnabled(boolean isEnabled) {
        this.checkNotClosed();
        SetAutofillEnabledRequest request = SetAutofillEnabledRequest.newBuilder().setProfileId(this.profile.id()).setIsEnabled(isEnabled).build();
        this.rpc.invoke(this.rpc.stub()::setAutofillEnabled, request);
    }
}

