/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.ChromiumCompatibility;
import com.teamdev.jxbrowser.view.swing.internal.dnd.ExportableCustomData;
import com.teamdev.jxbrowser.view.swing.internal.dnd.MacOsCompatibility;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class BrowserTransferable
implements Transferable {
    private static final DataFlavor HTML_FLAVOR = DataFlavor.fragmentHtmlFlavor;
    private static final DataFlavor JAVA_STRING_FLAVOR = DataFlavor.stringFlavor;
    private static final DataFlavor X_MOZ_URL_FLAVOR = new DataFlavor("text/x-moz-url", "URL");
    private static final DataFlavor JAVA_URL_FLAVOR = BrowserTransferable.stringFlavor("application/x-java-url", "URL");
    private static final DataFlavor URI_LIST_FLAVOR = BrowserTransferable.stringFlavor("text/uri-list", "URI list");
    private static final DataFlavor PLAIN_TEXT_FLAVOR = BrowserTransferable.stringFlavor("text/plain", "Plain text");
    private final Map<DataFlavor, Object> data = new HashMap<DataFlavor, Object>();

    private BrowserTransferable() {
    }

    static BrowserTransferable newInstance(DropData dropData) {
        BrowserTransferable transferable = new BrowserTransferable();
        transferable.setData(dropData);
        return transferable;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        Set<DataFlavor> dataFlavors = this.data.keySet();
        return dataFlavors.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.data.containsKey(flavor);
    }

    private void setData(DropData dropData) {
        ByteString customData;
        String url = dropData.getUrl();
        String text = dropData.getText();
        String html = dropData.getHtml();
        String htmlBaseUrl = dropData.getHtmlBaseUrl();
        if (!url.isEmpty()) {
            this.addData(JAVA_URL_FLAVOR, url);
            this.addData(PLAIN_TEXT_FLAVOR, url);
            this.addData(JAVA_STRING_FLAVOR, url);
            if (Environment.isLinux()) {
                this.addData(X_MOZ_URL_FLAVOR, url);
            }
            if (Environment.isMac()) {
                this.addData(MacOsCompatibility.SERIALIZED_URL_FLAVOR, MacOsCompatibility.serializeUrlForPasteboard(url));
            } else {
                this.addData(URI_LIST_FLAVOR, url);
            }
        }
        if (!htmlBaseUrl.isEmpty() || !html.isEmpty()) {
            this.addData(HTML_FLAVOR, html);
        }
        if (!text.isEmpty()) {
            this.addData(PLAIN_TEXT_FLAVOR, text);
            this.addData(JAVA_STRING_FLAVOR, text);
        }
        if (!(customData = dropData.getCustomData().getAsBytes()).isEmpty()) {
            this.addData(ChromiumCompatibility.CUSTOM_DATA_FLAVOR, new ExportableCustomData(customData.toByteArray()));
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.data.containsKey(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.data.get(flavor);
    }

    private void addData(DataFlavor flavor, Object transferData) {
        this.data.put(flavor, transferData);
    }

    private static DataFlavor stringFlavor(String mimeType, String name) {
        try {
            return new DataFlavor(mimeType + "; class=java.lang.String; charset=Unicode", name);
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to create a data flavor for the type: {0}", (Object[])new Object[]{e, mimeType});
            return null;
        }
    }
}

