/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.ChromiumCompatibility;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.ExportableCustomData;
import com.teamdev.jxbrowser.view.swing.internal.dnd.RichDataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

final class CustomDataType
extends DataType {
    CustomDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        try {
            if (Environment.isMac()) {
                byte[] dataInPasteboard = MacPasteboard.instance().readCustomData();
                ExportableCustomData data = ExportableCustomData.deserialize(dataInPasteboard);
                if (data != null && data.isNotEmpty()) {
                    DropData.CustomData customData = this.customData(data.bytesString());
                    dropData.setCustomData(customData);
                }
            } else if (transferable.isDataFlavorSupported(ChromiumCompatibility.CUSTOM_DATA_FLAVOR)) {
                ExportableCustomData data = (ExportableCustomData)transferable.getTransferData(ChromiumCompatibility.CUSTOM_DATA_FLAVOR);
                DropData.CustomData customData = this.customData(data.bytesString());
                dropData.setCustomData(customData);
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
    }

    protected List<RichDataFlavor<?>> supportedFlavors() {
        return Collections.emptyList();
    }

    private DropData.CustomData customData(ByteString data) {
        return DropData.CustomData.newBuilder().setAsBytes(data).build();
    }
}

