/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.callback.DragAndDropCallback;
import com.teamdev.jxbrowser.browser.internal.callback.StartDragCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserTransferable;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragImage;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragOperations;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.util.function.Consumer;
import javax.swing.TransferHandler;

final class DragLifecycleEvents {
    private final BrowserDragContext context;
    private final OffScreenRenderWidget component;

    static DragLifecycleEvents newInstance(OffScreenRenderWidget component, BrowserDragContext context) {
        Preconditions.checkNotNull((Object)context);
        return new DragLifecycleEvents(component, context);
    }

    private DragLifecycleEvents(OffScreenRenderWidget component, BrowserDragContext context) {
        this.component = component;
        this.context = context;
    }

    void startForwarding() {
        this.dragAndDrop().set(StartDragCallback.class, (DragAndDropCallback)((StartDragCallback)params -> {
            DropData dropData = params.getDropData();
            DragImage image = DragImage.createImage(params);
            this.context.browserDragOperation(dropData, image);
            return StartDrag.Response.newBuilder().build();
        }));
        this.context.dragGestureListener().delegate(event -> this.context.browserDragOperation().ifPresent(operation -> this.startDrag((DragGestureEvent)event, (BrowserDragContext.CurrentDragOperation)operation)));
    }

    void stopForwarding() {
        this.dragAndDrop().remove(StartDragCallback.class);
        this.context.dragGestureListener().resetDelegate();
    }

    private DragAndDrop dragAndDrop() {
        return this.component.widget().browser().dragAndDrop();
    }

    private void startDrag(DragGestureEvent event, BrowserDragContext.CurrentDragOperation operation) {
        DragImage dragImage = operation.dragImage();
        TransferHandler transferHandler = this.component.getTransferHandler();
        transferHandler.setDragImage(dragImage.toToolkit());
        transferHandler.setDragImageOffset(dragImage.offset());
        BrowserTransferable transferable = BrowserTransferable.newInstance(operation.dropData());
        event.getDragSource().startDrag(event, null, dragImage.toToolkit(), dragImage.offset(), transferable, this.wrap(this::endDrag));
    }

    private void endDrag(DragSourceDropEvent event) {
        Point location = this.component.scalePoint(event.getLocation());
        DragOperation operation = DragOperations.convert(event.getDropAction());
        this.component.widget().dragEnd(Point.empty(), location, operation);
        this.context.resetBrowserDragOperation();
    }

    private DragSourceListener wrap(final Consumer<DragSourceDropEvent> handler) {
        return new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent event) {
                handler.accept(event);
            }
        };
    }
}

