/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;

class ParentVisibilityTracker {
    private final Node node;
    private final VisibilityListener visibilityListener;
    private final ParentListener parentListener;

    private ParentVisibilityTracker(Builder builder) {
        this.node = builder.node;
        this.visibilityListener = new VisibilityListener(builder.onShow, builder.onHide);
        this.parentListener = new ParentListener();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    void start() {
        this.node.parentProperty().addListener((ChangeListener)this.parentListener);
    }

    void stop() {
        this.node.parentProperty().removeListener((ChangeListener)this.parentListener);
    }

    private class ParentListener
    implements ChangeListener<Parent> {
        private ParentListener() {
        }

        public void changed(ObservableValue<? extends Parent> observable, Parent oldValue, Parent newValue) {
            if (oldValue != null) {
                oldValue.visibleProperty().removeListener((ChangeListener)ParentVisibilityTracker.this.visibilityListener);
            }
            if (newValue != null) {
                newValue.visibleProperty().addListener((ChangeListener)ParentVisibilityTracker.this.visibilityListener);
            }
        }
    }

    private static class VisibilityListener
    implements ChangeListener<Boolean> {
        private final Runnable onShow;
        private final Runnable onHide;

        VisibilityListener(Runnable onShow, Runnable onHide) {
            this.onShow = onShow;
            this.onHide = onHide;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            Platform.runLater(() -> {
                if (newValue.booleanValue()) {
                    this.onShow.run();
                } else {
                    this.onHide.run();
                }
            });
        }
    }

    static class Builder {
        private Node node;
        private Runnable onShow;
        private Runnable onHide;

        Builder() {
        }

        Builder forNode(Node node) {
            this.node = node;
            return this;
        }

        Builder onShow(Runnable onShow) {
            this.onShow = onShow;
            return this;
        }

        Builder onHide(Runnable onHide) {
            this.onHide = onHide;
            return this;
        }

        ParentVisibilityTracker build() {
            return new ParentVisibilityTracker(this);
        }
    }
}

