/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.internal.CustomDropDataFormat;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;

final class Clipboard {
    private static final DataFormat CUSTOM_DATA_FORMAT;
    private final Dragboard dragboard;

    private Clipboard(Dragboard dragboard) {
        this.dragboard = dragboard;
    }

    static Clipboard of(Dragboard dragboard) {
        return new Clipboard(dragboard);
    }

    DropMetadata dropMetadata() {
        DropMetadata.Builder builder = DropMetadata.newBuilder();
        builder.setContainsUrl(this.dragboard.hasUrl());
        builder.setContainsText(this.dragboard.hasString());
        builder.setContainsHtml(this.dragboard.hasHtml());
        builder.setContainsFiles(this.dragboard.hasFiles());
        return builder.build();
    }

    DropData dropData() {
        Object content;
        byte[] data;
        DropData.Builder builder = DropData.newBuilder();
        if (this.dragboard.hasUrl()) {
            builder.setUrl(this.dragboard.getUrl());
            builder.setText(this.dragboard.getUrl());
        } else if (Environment.isMac()) {
            Optional.ofNullable(MacPasteboard.instance().readUrl()).ifPresent(arg_0 -> ((DropData.Builder)builder).setUrl(arg_0));
        }
        if (this.dragboard.hasString()) {
            String text = this.dragboard.getString();
            builder.setText(text);
        }
        if (this.dragboard.hasHtml()) {
            builder.setHtml(this.dragboard.getHtml());
        }
        if (this.dragboard.hasFiles()) {
            List files = this.dragboard.getFiles();
            for (File file : files) {
                builder.addFile(com.teamdev.jxbrowser.net.internal.rpc.File.newBuilder().setFilePath(file.getAbsolutePath()).build());
            }
        }
        if (Environment.isMac() && (data = MacPasteboard.instance().readCustomData()).length > 0) {
            DropData.CustomData customData = this.customData(ByteString.copyFrom((byte[])data));
            builder.setCustomData(customData);
        }
        if (this.dragboard.hasContent(CUSTOM_DATA_FORMAT) && (content = this.dragboard.getContent(CUSTOM_DATA_FORMAT)) instanceof ByteBuffer) {
            ByteBuffer data2 = (ByteBuffer)content;
            DropData.CustomData customData = this.customData(ByteString.copyFrom((ByteBuffer)data2));
            builder.setCustomData(customData);
        }
        return builder.build();
    }

    void setContent(DropData data) {
        ByteString customData;
        HashMap<DataFormat, Object> content = new HashMap<DataFormat, Object>();
        if (!data.getUrl().isEmpty()) {
            content.put(DataFormat.URL, data.getUrl());
            content.put(DataFormat.PLAIN_TEXT, data.getUrl());
        }
        if (!data.getText().isEmpty()) {
            content.put(DataFormat.PLAIN_TEXT, data.getText());
        }
        if (!data.getHtmlBaseUrl().isEmpty() || !data.getHtml().isEmpty()) {
            content.put(DataFormat.HTML, data.getHtml());
        }
        if (!(customData = data.getCustomData().getAsBytes()).isEmpty()) {
            content.put(CUSTOM_DATA_FORMAT, ByteBuffer.wrap(customData.toByteArray()));
        }
        this.dragboard.setContent(content);
    }

    private DropData.CustomData customData(ByteString data) {
        return DropData.CustomData.newBuilder().setAsBytes(data).build();
    }

    static {
        CustomDropDataFormat nativeDragFormat = CustomDropDataFormat.forCurrentPlatform();
        CUSTOM_DATA_FORMAT = new DataFormat(new String[]{nativeDragFormat.value()});
    }
}

