/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DefaultOpenPopupCallback
extends DefaultCallback
implements OpenPopupCallback {
    private static final int DEFAULT_POPUP_WIDTH = 800;
    private static final int DEFAULT_POPUP_HEIGHT = 600;

    public DefaultOpenPopupCallback(BrowserView parent) {
        super(parent);
    }

    public OpenPopupCallback.Response on(OpenPopupCallback.Params params) {
        Browser browser = params.popupBrowser();
        SafeExecutor.asyncExec((Widget)this.widget(), () -> {
            Display display = ((BrowserView)((Object)((Object)this.widget()))).getDisplay();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout());
            BrowserView view = BrowserView.newInstance((Composite)shell, browser);
            Rect initialBounds = params.initialBounds();
            DefaultOpenPopupCallback.updateOrigin(shell, initialBounds.origin());
            DefaultOpenPopupCallback.updateSize(shell, view, initialBounds.size());
            shell.addDisposeListener(event -> {
                if (!browser.isClosed()) {
                    SafeExecutor.asyncExec((Widget)this.widget(), () -> ((Browser)browser).close());
                }
            });
            browser.on(TitleChanged.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> shell.setText(event.title())));
            browser.on(BrowserClosed.class, event -> SafeExecutor.asyncExec((Widget)shell, () -> ((Shell)shell).dispose()));
            browser.on(UpdateBoundsRequested.class, event -> DefaultOpenPopupCallback.updateBounds(event, shell, view));
            view.setVisible(true);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }, OpenPopupCallback.Response::proceed);
        return OpenPopupCallback.Response.proceed();
    }

    private static void updateBounds(UpdateBoundsRequested event, Shell shell, BrowserView view) {
        SafeExecutor.asyncExec((Widget)shell, () -> {
            Rect newBounds = event.bounds();
            Size newSize = newBounds.size();
            if (!DefaultOpenPopupCallback.currentSize(view).equals(newSize)) {
                DefaultOpenPopupCallback.updateSize(shell, view, newSize);
            }
            Point newOrigin = newBounds.origin();
            if (!DefaultOpenPopupCallback.currentOrigin(view).equals(newOrigin)) {
                DefaultOpenPopupCallback.updateOrigin(shell, newOrigin);
            }
        });
    }

    private static Point currentOrigin(BrowserView view) {
        org.eclipse.swt.graphics.Point viewLocation = view.toDisplay(0, 0);
        return Geometry.newPoint((double)viewLocation.x, (double)viewLocation.y);
    }

    private static Size currentSize(BrowserView view) {
        org.eclipse.swt.graphics.Point boundsInLocal = view.getSize();
        return Size.of((int)boundsInLocal.x, (int)boundsInLocal.y);
    }

    private static void updateOrigin(Shell shell, Point newOrigin) {
        shell.setLocation(newOrigin.x(), newOrigin.y());
    }

    private static void updateSize(Shell shell, BrowserView view, Size newSize) {
        if (newSize.isEmpty()) {
            view.setSize(800, 600);
        } else {
            view.setSize(newSize.width(), newSize.height());
        }
        org.eclipse.swt.graphics.Point newPreferredSize = shell.computeSize(-1, -1, true);
        shell.setSize(newPreferredSize);
    }
}

