/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.engine.internal.UnixCommandHelper;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ChromiumLibraryPatcher {
    private final String workingDir;

    public ChromiumLibraryPatcher(String workingDir) {
        this.workingDir = workingDir;
    }

    public void patchLibrary(String name, String template) {
        String[] possibleLocations;
        String expectedPath = this.getExpectedLibraryPath();
        String expectedLibraryPath = expectedPath + name;
        if (this.libraryExists(expectedLibraryPath)) {
            Logger.debug("{0}... exists", expectedLibraryPath);
            return;
        }
        String localDirectory = this.workingDir + File.separator;
        String symlink = localDirectory + name;
        if (this.libraryExists(symlink) && this.verifySymlink(symlink)) {
            Logger.debug("{0}... symlink exists and is valid", symlink);
            return;
        }
        File systemLibrary = null;
        for (String libraryPath : possibleLocations = this.possibleLibraryLocations()) {
            Logger.debug("Looking for {0} x.x.x in {1} library path ...", template, libraryPath);
            systemLibrary = Files.findByTemplate(libraryPath, template);
            if (systemLibrary == null) continue;
            Logger.debug("Found the {0} library", systemLibrary.getAbsolutePath());
            String command = "/bin/ln -s " + systemLibrary.getAbsolutePath() + ' ' + localDirectory + name;
            Logger.debug("Creating symlink: {0}", command);
            try {
                int exitCode = Runtime.getRuntime().exec(command).waitFor();
                Logger.debug("{0} : symlink has been created. Exit code: {1}", command, exitCode);
            }
            catch (IOException | InterruptedException e) {
                Logger.error("{0}... [FAIL]", (Throwable)e, command);
            }
            break;
        }
        if (systemLibrary == null) {
            Logger.warn("Failed to find {0}x.x.x", template);
        }
    }

    private boolean verifySymlink(String linkPath) {
        AtomicBoolean result = new AtomicBoolean(false);
        new UnixCommandHelper().findExecutablePath("ls").ifPresent(lsCommandPath -> {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(lsCommandPath.toString(), "-l", linkPath);
            try {
                Process process = processBuilder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    this.parseOutput(process.getInputStream()).ifPresent(actualLibLocation -> result.set(this.libraryExists((String)actualLibLocation)));
                } else {
                    this.logError(process.getErrorStream());
                }
            }
            catch (IOException | InterruptedException e) {
                Logger.warn(e, () -> "ls -l " + linkPath + " ... [FAIL]");
            }
        });
        return result.get();
    }

    private boolean libraryExists(String path) {
        File library = new File(path);
        return library.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> parseOutput(InputStream inputStream) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
            String line = reader.readLine();
            String[] symLinkTarget = line.split("->", -1);
            if (symLinkTarget.length == 2) {
                Optional<String> optional = Optional.of(symLinkTarget[1]);
                return optional;
            }
        }
        finally {
            inputStream.close();
        }
        return Optional.empty();
    }

    private void logError(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, Charset.defaultCharset().name()).useDelimiter("\\A");
        Logger.info(scanner.hasNext() ? scanner.next().trim() : "");
        inputStream.close();
    }

    private String[] possibleLibraryLocations() {
        if (Environment.isArm()) {
            return new String[]{"/lib/aarch64-linux-gnu/", "/lib/", "/usr/lib/"};
        }
        return new String[]{"/lib/x86_64-linux-gnu/", "/lib64/", "/usr/lib64/"};
    }

    private String getExpectedLibraryPath() {
        if (Environment.is64Bit()) {
            if (Environment.isArm()) {
                return "/lib/aarch64-linux-gnu/";
            }
            return "/lib/x86_64-linux-gnu/";
        }
        throw new IllegalStateException("Unsupported operating system.");
    }
}

