/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableBiMap;
import javafx.scene.input.TransferMode;

final class TransferModes {
    private static final ImmutableBiMap<TransferMode, DragOperation> correspondence = ImmutableBiMap.builder().put((Object)TransferMode.COPY, (Object)DragOperation.OPERATION_COPY).put((Object)TransferMode.MOVE, (Object)DragOperation.OPERATION_MOVE).put((Object)TransferMode.LINK, (Object)DragOperation.OPERATION_LINK).build();

    private TransferModes() {
    }

    static TransferMode[] of(DragOperation dragOperation) {
        if (dragOperation == DragOperation.OPERATION_NONE) {
            return TransferMode.NONE;
        }
        TransferMode transferMode = (TransferMode)correspondence.inverse().get((Object)dragOperation);
        if (transferMode == null) {
            return TransferModes.singletonArray(TransferMode.COPY);
        }
        return TransferModes.singletonArray(transferMode);
    }

    static DragOperation toDragOperation(TransferMode transferMode) {
        DragOperation dragOperation = (DragOperation)correspondence.get((Object)transferMode);
        if (dragOperation == null) {
            return DragOperation.OPERATION_NONE;
        }
        return dragOperation;
    }

    static int toDragOperationMask(TransferMode ... transferModes) {
        int result = 0;
        for (TransferMode transferMode : transferModes) {
            DragOperation operation = (DragOperation)correspondence.get((Object)transferMode);
            if (operation == null) continue;
            result |= operation.getNumber();
        }
        return result;
    }

    private static TransferMode[] singletonArray(TransferMode transferMode) {
        return new TransferMode[]{transferMode};
    }
}

