/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.ApproximateBounds;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class DefaultOpenPopupCallback
implements OpenPopupCallback {
    private static final Size DEFAULT_POPUP_SIZE = Size.of((int)800, (int)600);

    public OpenPopupCallback.Response on(OpenPopupCallback.Params params) {
        final Browser browser = params.popupBrowser();
        SwingUtilities.invokeLater(() -> {
            BrowserView view = BrowserView.newInstance(browser);
            JFrame frame = new JFrame();
            frame.add((Component)view, "Center");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SwingUtilities.invokeLater(() -> ((Browser)browser).close());
                }
            });
            DefaultOpenPopupCallback.updateInitialBounds(frame, params.initialBounds(), params.scaleFactor());
            browser.on(TitleChanged.class, event -> SwingUtilities.invokeLater(() -> frame.setTitle(event.title())));
            browser.on(BrowserClosed.class, event -> SwingUtilities.invokeLater(() -> {
                frame.setVisible(false);
                frame.dispose();
            }));
            browser.on(UpdateBoundsRequested.class, event -> DefaultOpenPopupCallback.updateBounds(event, frame, view));
            frame.setVisible(true);
        });
        return OpenPopupCallback.Response.proceed();
    }

    private static void updateBounds(UpdateBoundsRequested event, JFrame frame, BrowserView view) {
        SwingUtilities.invokeLater(() -> {
            Rect newBounds;
            double scaleFactor = event.scaleFactor();
            Rect eventBounds = event.bounds();
            Rect rect = newBounds = DefaultOpenPopupCallback.shouldAdjustScaling() ? Geometry.scaleUp((Rect)eventBounds, (double)scaleFactor) : eventBounds;
            if (!ApproximateBounds.fuzzyEqual((Size)DefaultOpenPopupCallback.currentSize(view), (Size)newBounds.size())) {
                DefaultOpenPopupCallback.updateSize(frame, eventBounds.size(), scaleFactor);
            }
            if (!ApproximateBounds.fuzzyEqual((Point)DefaultOpenPopupCallback.currentOrigin(view), (Point)newBounds.origin())) {
                DefaultOpenPopupCallback.updateOrigin(frame, eventBounds.origin(), scaleFactor);
            }
            frame.pack();
        });
    }

    private static Point currentOrigin(BrowserView view) {
        java.awt.Point locationOnScreen = view.getLocationOnScreen();
        return Geometry.newPoint((double)locationOnScreen.getX(), (double)locationOnScreen.getY());
    }

    private static Size currentSize(BrowserView view) {
        Rectangle bounds = view.getBounds();
        return Size.of((int)bounds.width, (int)bounds.height);
    }

    private static void updateInitialBounds(JFrame frame, Rect bounds, double scaleFactor) {
        DefaultOpenPopupCallback.updateOrigin(frame, bounds.origin(), scaleFactor);
        DefaultOpenPopupCallback.updateSize(frame, bounds.size(), scaleFactor);
        frame.pack();
    }

    private static void updateOrigin(JFrame frame, Point origin, double scaleFactor) {
        if (DefaultOpenPopupCallback.shouldAdjustScaling()) {
            origin = Geometry.scaleUp((Point)origin, (double)scaleFactor);
        }
        frame.setLocation(ToolkitConverters.toPoint(origin));
    }

    private static void updateSize(JFrame frame, Size size, double scaleFactor) {
        if (size.isEmpty()) {
            frame.setSize(ToolkitConverters.toDimension(DEFAULT_POPUP_SIZE));
            return;
        }
        if (DefaultOpenPopupCallback.shouldAdjustScaling()) {
            size = Geometry.scaleUp((Size)size, (double)scaleFactor);
        }
        frame.getContentPane().setPreferredSize(ToolkitConverters.toDimension(size));
    }

    private static boolean shouldAdjustScaling() {
        return !Platform.instance().isDpiAware();
    }
}

