/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.browser.callback.SelectClientCertificateCallback;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.net.tls.X509Certificates;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.callback.DefaultCallback;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class DefaultSelectClientCertificateCallback
extends DefaultCallback
implements SelectClientCertificateCallback {
    public DefaultSelectClientCertificateCallback(BrowserView parent) {
        super(parent);
    }

    public void on(SelectClientCertificateCallback.Params params, SelectClientCertificateCallback.Action tell) {
        List certificates = params.certificates();
        if (certificates.isEmpty()) {
            tell.cancel();
            return;
        }
        SwingUtilities.invokeLater(() -> {
            ArrayList<String> selectionValues = new ArrayList<String>();
            try {
                for (Certificate certificate : certificates) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(certificate.derEncodedValue());
                    X509Certificate x509Certificate = X509Certificates.of((InputStream)inputStream);
                    selectionValues.add(x509Certificate.getSubjectDN().getName());
                }
            }
            catch (CertificateException ex) {
                Logger.error((String)"Failed to parse an X509Certificate.", (Throwable)ex);
                tell.cancel();
                return;
            }
            String title = params.title();
            String message = params.message();
            String selectActionText = params.selectActionText();
            String cancelActionText = params.cancelActionText();
            JComboBox<String> comboBox = new JComboBox<String>(selectionValues.toArray(new String[0]));
            Object[] components = new Object[]{new JLabel(message), comboBox};
            Object[] options = new Object[]{selectActionText, cancelActionText};
            int returnValue = JOptionPane.showOptionDialog((Component)this.widget(), components, title, 2, -1, null, options, options[0]);
            if (returnValue == 0 && comboBox.getSelectedIndex() != -1) {
                tell.select(comboBox.getSelectedIndex());
            } else {
                tell.cancel();
            }
        });
    }
}

