/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.DisplayWatcher;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

class DisplayWatcher
extends com.teamdev.jxbrowser.internal.DisplayWatcher<Window> {
    private final WindowListener windowListener = new WindowListener();
    private Window window;

    private DisplayWatcher(DisplayWatcher.Observer observer) {
        super(observer);
    }

    static DisplayWatcher newInstance(DisplayWatcher.Observer observer) {
        if (SystemProperties.hasProperty((String)"jxbrowser.desktop.headless.on") || Environment.isLinux()) {
            return new NopDisplayWatcher();
        }
        return new DisplayWatcher(observer);
    }

    private void notifyWindowStateChanged() {
        if (this.window != null) {
            long windowHandle = AwtHelperLibrary.instance().getWindowHandle(this.window);
            String displayId = ToolkitLibrary.instance().getDisplayIdForWindow(windowHandle);
            double scaleFactor = this.scaleFactor(displayId);
            this.changeDisplay(new Display(displayId, scaleFactor));
        }
    }

    public void attach(Window window) {
        if (window != null) {
            this.window = window;
            window.addComponentListener(this.windowListener);
            this.notifyWindowStateChanged();
        }
    }

    public void detach() {
        if (this.window != null) {
            this.window.removeComponentListener(this.windowListener);
        }
    }

    private double scaleFactor(String displayId) {
        String property = System.getProperty("jxbrowser.force.device.scale.factor");
        if (property != null) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(e);
            }
        }
        return ToolkitLibrary.instance().getScaleFactorForDisplay(displayId);
    }

    private final class WindowListener
    extends ComponentAdapter {
        private WindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DisplayWatcher.this.notifyWindowStateChanged();
        }
    }

    public static final class NopDisplayWatcher
    extends DisplayWatcher {
        private NopDisplayWatcher() {
            super(null);
        }

        @Override
        public void attach(Window window) {
        }

        @Override
        public void detach() {
        }
    }
}

