/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.WebDialogCreated;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.swing.internal.Graphics2dWebDialogView;
import com.teamdev.jxbrowser.view.swing.internal.MemoryImage;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class Graphics2dRenderWidget
extends OffScreenRenderWidget {
    private final MemoryImage memoryImage;
    private final Subscription webDialogCreated;

    public Graphics2dRenderWidget(BrowserWidget widget) {
        super(widget);
        this.setLayout(null);
        BrowserImpl browser = widget.browser();
        this.memoryImage = new MemoryImage();
        this.webDialogCreated = widget.on(WebDialogCreated.class, event -> {
            WebDialog webDialog = new WebDialog(browser, event.getWebDialogId());
            Graphics2dWebDialogView webDialogView = new Graphics2dWebDialogView(webDialog);
            webDialogView.setBounds(Geometry.scaleUp((com.teamdev.jxbrowser.ui.Rect)event.getInitialBounds(), (double)event.getScaleFactor()));
            SwingUtilities.invokeLater(() -> {
                this.add(webDialogView);
                this.validate();
                this.repaint();
            });
            webDialog.on(DialogBoundsUpdated.class, e -> SwingUtilities.invokeLater(() -> {
                webDialogView.setBounds(Geometry.scaleUp((com.teamdev.jxbrowser.ui.Rect)e.getBounds(), (double)e.getScaleFactor()));
                this.validate();
                this.repaint();
            }));
            webDialog.on(DialogClosed.class, e -> SwingUtilities.invokeLater(() -> {
                this.remove(webDialogView);
                this.validate();
                this.repaint();
                if (!widget.isClosed()) {
                    widget.focus();
                }
            }));
        });
        this.widget().set(PaintCallback.class, (BrowserWidgetCallback)new OnPaint());
    }

    @Override
    protected void close() {
        if (this.webDialogCreated != null) {
            this.webDialogCreated.unsubscribe();
        }
        this.widget().remove(PaintCallback.class);
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (Platform.instance().isDpiAware()) {
            double scale = 1.0 / this.memoryImage.deviceScaleFactor();
            g2d.scale(scale, scale);
        }
        Graphics2dRenderWidget graphics2dRenderWidget = this;
        synchronized (graphics2dRenderWidget) {
            this.memoryImage.image().ifPresent(image -> g.drawImage((Image)image, 0, 0, this));
        }
        this.widget().onPainted();
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }

    private void repaintIfShown(Rectangle rectangle) {
        SwingUtilities.invokeLater(() -> {
            if (this.isShown()) {
                this.repaint(rectangle);
            }
        });
    }

    private final class OnPaint
    implements PaintCallback {
        private OnPaint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Paint.Response on(Paint.Request params) {
            Graphics2dRenderWidget graphics2dRenderWidget = Graphics2dRenderWidget.this;
            synchronized (graphics2dRenderWidget) {
                PaintRequest request = params.getPaintRequest();
                com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = request.getViewSize();
                Rect dirtyRect = request.getDirtyRect();
                if (!Graphics2dRenderWidget.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                    return Paint.Response.newBuilder().build();
                }
                Graphics2dRenderWidget.this.memoryImage.updatePixels((Size)viewSize, (com.teamdev.jxbrowser.ui.Rect)dirtyRect, request.getMemoryId(), request.getScaleFactor(), x$0 -> Graphics2dRenderWidget.this.repaintIfShown(x$0));
            }
            return Paint.Response.newBuilder().build();
        }
    }
}

