/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.callback.internal.ShowSuggestionsCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.Suggestion;
import com.teamdev.jxbrowser.suggestions.SuggestionsPopupType;
import com.teamdev.jxbrowser.ui.internal.rpc.Point;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class SuggestionsPopup {
    private static final Map<BrowserId, SuggestionsPopup> OPEN_POPUPS = new ConcurrentHashMap<BrowserId, SuggestionsPopup>();
    private final ShowSuggestionsCallback.Params params;
    private final ShowSuggestionsCallback.Action action;
    private final BrowserView parent;
    private final JPopupMenu suggestionsPopup;

    static Optional<SuggestionsPopup> fromBrowser(BrowserId id) {
        return Optional.ofNullable(OPEN_POPUPS.get(id));
    }

    public SuggestionsPopup(BrowserView parent, ShowSuggestionsCallback.Params params, ShowSuggestionsCallback.Action action) {
        this.parent = parent;
        this.params = params;
        this.action = action;
        this.suggestionsPopup = new JPopupMenu();
        this.suggestionsPopup.addPopupMenuListener(new SuggestionsPopupListener(this, action, ((BrowserImpl)parent.getBrowser()).id()));
    }

    private void addSuggestions(List<Suggestion> suggestions) {
        for (Suggestion suggestion : suggestions) {
            JMenuItem suggestionItem = this.createSuggestionItem(this.params, suggestion);
            suggestionItem.addActionListener(actionEvent -> {
                if (!this.action.isClosed()) {
                    this.action.accept(suggestion);
                }
            });
            this.suggestionsPopup.add((Component)suggestionItem, suggestion.getIndex());
        }
    }

    private JMenuItem createSuggestionItem(ShowSuggestionsCallback.Params params, Suggestion suggestion) {
        JMenuItem suggestionItem = new JMenuItem();
        String text = params.popupType() == SuggestionsPopupType.PASSWORDS ? String.format("%s  %s", suggestion.getValue(), suggestion.getHiddenPassword()) : (params.popupType() == SuggestionsPopupType.ADDRESSES ? String.format("%s  %s", suggestion.getValue(), suggestion.getAddressOrFullname()) : suggestion.getValue());
        suggestionItem.setBackground(Color.WHITE);
        suggestionItem.setText(text);
        return suggestionItem;
    }

    public void show() {
        this.suggestionsPopup.setLightWeightPopupEnabled(false);
        this.suggestionsPopup.setOpaque(true);
        this.suggestionsPopup.setFocusable(false);
        this.suggestionsPopup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Point location = this.params.location();
        java.awt.Point point = new java.awt.Point(location.x(), location.y());
        SwingUtilities.convertPointFromScreen(point, this.parent);
        this.addSuggestions(this.params.suggestions());
        SwingUtilities.invokeLater(() -> this.suggestionsPopup.show(this.parent, point.x, point.y));
    }

    void updateSuggestions(List<Suggestion> updatedSuggestions) {
        SwingUtilities.invokeLater(() -> {
            if (this.suggestionsPopup.getComponents().length == updatedSuggestions.size()) {
                return;
            }
            if (this.suggestionsPopup.isVisible()) {
                this.suggestionsPopup.setVisible(false);
            }
            this.suggestionsPopup.removeAll();
            this.addSuggestions(updatedSuggestions);
            this.suggestionsPopup.setVisible(true);
        });
    }

    void hide() {
        SwingUtilities.invokeLater(() -> {
            if (this.suggestionsPopup.isVisible()) {
                this.suggestionsPopup.setVisible(false);
            }
            if (!this.action.isClosed()) {
                this.action.cancel();
            }
        });
    }

    private static final class SuggestionsPopupListener
    implements PopupMenuListener {
        private final ShowSuggestionsCallback.Action action;
        private final BrowserId browserId;
        private final SuggestionsPopup popup;

        private SuggestionsPopupListener(SuggestionsPopup popup, ShowSuggestionsCallback.Action action, BrowserId browserId) {
            this.popup = popup;
            this.action = action;
            this.browserId = browserId;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            OPEN_POPUPS.put(this.browserId, this.popup);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            OPEN_POPUPS.remove(this.browserId);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            if (!this.action.isClosed()) {
                this.action.cancel();
            }
        }
    }
}

