/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Point;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.javafx.internal.Graphics2dWebDialogView;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import com.teamdev.jxbrowser.view.javafx.internal.MemoryImage;
import com.teamdev.jxbrowser.view.javafx.internal.OffScreenRenderWidget;
import javafx.application.Platform;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Affine;
import javax.annotation.CheckForNull;

public class Graphics2dRenderWidget
extends OffScreenRenderWidget {
    private final MemoryImage memoryImage = new MemoryImage();

    public Graphics2dRenderWidget(BrowserWidget widget) {
        super(widget);
        this.widget().set(PaintCallback.class, (BrowserWidgetCallback)new OnPaint());
        widget.set(CreateWebDialogCallback.class, (BrowserWidgetCallback)((CreateWebDialogCallback)params -> {
            WebDialog webDialog = new WebDialog(widget.browser(), params.getWebDialogId());
            Graphics2dWebDialogView webDialogView = new Graphics2dWebDialogView(webDialog);
            webDialogView.addEventHandler(EventType.ROOT, arg_0 -> ((Graphics2dRenderWidget)this).fireEvent(arg_0));
            StackPane browserView = (StackPane)this.getParent();
            Platform.runLater(() -> {
                Rect initialBounds = params.getInitialBounds();
                webDialogView.setSize(initialBounds.size());
                Point origin = initialBounds.getOrigin();
                StackPane.setMargin((Node)webDialogView, (Insets)new Insets((double)origin.y(), 0.0, 0.0, (double)origin.x()));
                StackPane.setAlignment((Node)webDialogView, (Pos)Pos.TOP_LEFT);
                browserView.getChildren().add((Object)webDialogView);
                browserView.layout();
            });
            webDialog.on(DialogBoundsUpdated.class, e -> Platform.runLater(() -> webDialogView.setSize(e.getBounds().size())));
            webDialog.on(DialogClosed.class, e -> Platform.runLater(() -> {
                webDialogView.close();
                webDialogView.removeEventHandler(EventType.ROOT, arg_0 -> ((Graphics2dRenderWidget)this).fireEvent(arg_0));
                browserView.getChildren().remove((Object)webDialogView);
                browserView.layout();
            }));
            return CreateWebDialog.Response.newBuilder().build();
        }));
    }

    @Override
    protected void close() {
        this.widget().remove(PaintCallback.class);
        this.widget().remove(CreateWebDialogCallback.class);
        super.close();
    }

    @Override
    protected void show() {
        if (this.isBrowserWidgetShown()) {
            return;
        }
        super.show();
        Platform.runLater(this::paint);
    }

    @Override
    protected void hide() {
        if (!this.isBrowserWidgetShown()) {
            return;
        }
        super.hide();
    }

    @Override
    protected boolean alwaysTrackSize() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint() {
        GraphicsContext graphics2d = this.getGraphicsContext2D();
        MemoryImage memoryImage = this.memoryImage;
        synchronized (memoryImage) {
            double deviceScaleFactor = this.memoryImage.getDeviceScaleFactor();
            if (HiDpi.isPlatformDpiAware(deviceScaleFactor)) {
                double scale = 1.0 / deviceScaleFactor;
                Affine transform = graphics2d.getTransform();
                transform.setMxx(scale);
                transform.setMyy(scale);
                graphics2d.setTransform(transform);
            }
            WritableImage image = this.memoryImage.getImage();
            graphics2d.clearRect(0.0, 0.0, image.getWidth(), image.getHeight());
            graphics2d.drawImage((Image)image, 0.0, 0.0, image.getWidth(), image.getHeight());
        }
        this.widget().onPainted();
    }

    private final class OnPaint
    implements PaintCallback {
        private OnPaint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Paint.Response on(Paint.Request params) {
            MemoryImage memoryImage = Graphics2dRenderWidget.this.memoryImage;
            synchronized (memoryImage) {
                PaintRequest request = params.getPaintRequest();
                Graphics2dRenderWidget.this.memoryImage.updateImage((Size)request.getViewSize(), (com.teamdev.jxbrowser.ui.Rect)request.getDirtyRect(), request.getMemoryId(), request.getScaleFactor());
            }
            if (Graphics2dRenderWidget.this.isBrowserWidgetShown()) {
                Platform.runLater(() -> Graphics2dRenderWidget.this.paint());
            }
            return Paint.Response.getDefaultInstance();
        }
    }
}

