/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.DoneTabbing;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.internal.AncestorsVisibilityTracker;
import com.teamdev.jxbrowser.view.javafx.internal.BrowserNode;
import com.teamdev.jxbrowser.view.javafx.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.javafx.internal.FocusTraversal;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import com.teamdev.jxbrowser.view.javafx.internal.NodeVisibility;
import com.teamdev.jxbrowser.view.javafx.internal.ParentTabTracker;
import com.teamdev.jxbrowser.view.javafx.internal.window.FxPanel;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Transform;
import javafx.stage.Stage;
import javafx.stage.Window;

public class WindowedWidget
extends StackPane
implements BrowserNode {
    private final Subscription browserClosed;
    private final FocusListener focusListener;
    private final SizeChangedListener widthListener;
    private final SizeChangedListener heightListener;
    private final SceneWindowListener sceneWindowListener;
    private final SceneChangeListener sceneChangeListener;
    private final WindowShowingListener windowShowingListener;
    private final WindowLocationListener windowLocationListener;
    private final WindowIconifiedListener windowIconifiedListener;
    private final GlobalFocusOwnerListener globalFocusOwnerListener;
    private final SceneBasedPositionListener sceneBasedPositionListener;
    private final NodeVisibility nodeVisibility;
    private final ParentTabTracker parentTabTracker;
    private final AncestorsVisibilityTracker ancestorsVisibilityTracker;
    private final BrowserWidget widget;
    private final DisplayWatcher displayWatcher;
    private State state;
    private Scene scene;
    private Display display;
    private Subscription focusGained;
    private NativeAwareWindow window;
    private Subscription windowedDoneTabbing;

    public WindowedWidget(BrowserWidget widget) {
        this.widget = widget;
        this.state = State.DETACHED;
        this.focusListener = new FocusListener();
        this.widthListener = new SizeChangedListener();
        this.heightListener = new SizeChangedListener();
        this.sceneWindowListener = new SceneWindowListener();
        this.windowLocationListener = new WindowLocationListener();
        this.windowShowingListener = new WindowShowingListener();
        this.globalFocusOwnerListener = new GlobalFocusOwnerListener();
        this.sceneChangeListener = new SceneChangeListener();
        this.sceneBasedPositionListener = new SceneBasedPositionListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
        this.parentTabTracker = ParentTabTracker.newBuilder().forNode((Node)this).whenTabSelected(this::show).whenTabDeselected(this::hide).build();
        this.ancestorsVisibilityTracker = AncestorsVisibilityTracker.newBuilder().forNode((Node)this).onShow(this::show).onHide(this::hide).build();
        this.nodeVisibility = NodeVisibility.newInstance(this);
        this.display = Display.primaryDisplay();
        this.displayWatcher = DisplayWatcher.newInstance(this::onDisplayChanged);
        this.setFocusTraversable(true);
        this.ancestorsVisibilityTracker.start();
        this.sceneProperty().addListener((ChangeListener)this.sceneChangeListener);
        this.localToSceneTransformProperty().addListener((ChangeListener)this.sceneBasedPositionListener);
        this.browserClosed = widget.browser().on(BrowserClosed.class, event -> this.close());
    }

    private void close() {
        this.hide();
        this.sceneProperty().removeListener((ChangeListener)this.sceneChangeListener);
        this.localToSceneTransformProperty().removeListener((ChangeListener)this.sceneBasedPositionListener);
        this.parentTabTracker.stop();
        this.removeSceneListeners();
        this.removeWindowListeners();
        this.ancestorsVisibilityTracker.stop();
        this.browserClosed.unsubscribe();
        if (Environment.isWindows()) {
            Platform.runLater(this::reFocusNativeWindow);
        }
    }

    private void setFocus(boolean focus) {
        if (focus) {
            this.widget.focus();
        } else {
            this.widget.unfocus();
        }
    }

    private void show() {
        if (this.state == State.ATTACHED || this.nodeVisibility.isNotVisible()) {
            return;
        }
        this.heightProperty().addListener((ChangeListener)this.heightListener);
        this.widthProperty().addListener((ChangeListener)this.widthListener);
        this.focusedProperty().addListener((ChangeListener)this.focusListener);
        this.focusGained = this.widget.browser().on(FocusGained.class, event -> Platform.runLater(() -> ((WindowedWidget)this).requestFocus()));
        this.windowedDoneTabbing = this.widget.on(DoneTabbing.class, event -> Platform.runLater(() -> FocusTraversal.traverseFocus((Node)this, event)));
        this.attach();
    }

    private synchronized void hide() {
        if (this.state == State.DETACHED) {
            return;
        }
        this.unregisterWidgetListeners();
        if (!this.widget.isClosed()) {
            this.widget.hide();
        }
        this.state = State.DETACHED;
    }

    private void unregisterWidgetListeners() {
        this.focusedProperty().removeListener((ChangeListener)this.focusListener);
        this.widthProperty().removeListener((ChangeListener)this.widthListener);
        this.heightProperty().removeListener((ChangeListener)this.heightListener);
        if (this.focusGained != null) {
            this.focusGained.unsubscribe();
        }
        if (this.windowedDoneTabbing != null) {
            this.windowedDoneTabbing.unsubscribe();
        }
    }

    private void detach() {
        if (Environment.isLinux()) {
            this.widget.detach();
        }
    }

    private void attach() {
        if (this.nodeVisibility.isNotVisible()) {
            return;
        }
        Size initialSize = Size.of((int)((int)this.getWidth()), (int)((int)this.getHeight()));
        if (!HiDpi.isPlatformDpiAware(this.display.scaleFactor())) {
            initialSize = Geometry.scaleDown((Size)initialSize, (double)this.display.scaleFactor());
        }
        this.widget.attach(this.window.nativeId(), this::onAttached, this::onAttachFailed, initialSize);
    }

    private void onAttached() {
        Platform.runLater(() -> {
            if (this.nodeVisibility.isVisibleOnScene()) {
                this.widget.show();
                this.displayWatcher.notifyWindowStateChanged();
                this.notifyBoundsUpdated();
                this.state = State.ATTACHED;
            }
        });
    }

    private void onAttachFailed() {
        Platform.runLater(this::close);
    }

    @Override
    public NativeAwareWindow window() {
        return this.window;
    }

    private void notifyBoundsUpdated() {
        if (this.nodeVisibility.isNotVisible()) {
            return;
        }
        int width = (int)this.getWidth();
        int height = (int)this.getHeight();
        Scene scene = this.getScene();
        if (width > 0 && height > 0 && scene != null) {
            Point2D widgetLocation = this.localToScreen(0.0, 0.0);
            double screenX = widgetLocation.getX();
            double screenY = widgetLocation.getY();
            double sceneX = scene.getX();
            double sceneY = scene.getY();
            Window window = scene.getWindow();
            double windowX = window.getX();
            double windowY = window.getY();
            Point inWindow = Point.of((int)((int)Math.round(screenX - windowX - sceneX)), (int)((int)Math.round(screenY - windowY - sceneY)));
            inWindow = this.adjustForFxPanel(window, inWindow);
            Rect boundsInWindow = Geometry.newRect((double)inWindow.x(), (double)inWindow.y(), (double)width, (double)height);
            Rect boundsInScreen = Geometry.newRect((double)screenX, (double)screenY, (double)width, (double)height);
            if (!HiDpi.isPlatformDpiAware(this.display.scaleFactor())) {
                boundsInWindow = Geometry.scaleDown((Rect)boundsInWindow, (double)this.display.scaleFactor());
                boundsInScreen = Geometry.scaleDown((Rect)boundsInScreen, (double)this.display.scaleFactor());
            }
            this.widget.bounds(boundsInWindow, boundsInScreen);
        }
    }

    private Point adjustForFxPanel(Window window, Point point) {
        return FxPanel.findFor(window).map(panel -> panel.toAwtCoordinates(point)).orElse(point);
    }

    private void addWindowListeners() {
        if (this.window != null) {
            Window toolkitWindow = this.window.toolkitWindow();
            toolkitWindow.xProperty().addListener((ChangeListener)this.windowLocationListener);
            toolkitWindow.yProperty().addListener((ChangeListener)this.windowLocationListener);
            toolkitWindow.showingProperty().addListener((ChangeListener)this.windowShowingListener);
            if (toolkitWindow instanceof Stage) {
                ((Stage)toolkitWindow).iconifiedProperty().addListener((ChangeListener)this.windowIconifiedListener);
            }
            this.displayWatcher.attach(this.window);
        }
    }

    private void removeWindowListeners() {
        if (this.window != null) {
            Window toolkitWindow = this.window.toolkitWindow();
            toolkitWindow.xProperty().removeListener((ChangeListener)this.windowLocationListener);
            toolkitWindow.yProperty().removeListener((ChangeListener)this.windowLocationListener);
            toolkitWindow.showingProperty().removeListener((ChangeListener)this.windowShowingListener);
            if (toolkitWindow instanceof Stage) {
                ((Stage)toolkitWindow).iconifiedProperty().removeListener((ChangeListener)this.windowIconifiedListener);
            }
            this.displayWatcher.detach();
        }
    }

    private void setWindow(Window newWindow) {
        if (this.window != null) {
            this.removeWindowListeners();
            this.window.removeEventListeners();
            this.hide();
        }
        if (newWindow != null) {
            this.window = NativeAwareWindow.newInstance(newWindow);
            this.addWindowListeners();
            this.show();
        } else {
            this.window = null;
        }
    }

    private void addSceneListeners() {
        if (this.scene != null) {
            this.scene.focusOwnerProperty().addListener((ChangeListener)this.globalFocusOwnerListener);
            this.scene.windowProperty().addListener((ChangeListener)this.sceneWindowListener);
        }
    }

    private void removeSceneListeners() {
        if (this.scene != null) {
            this.scene.focusOwnerProperty().removeListener((ChangeListener)this.globalFocusOwnerListener);
            this.scene.windowProperty().removeListener((ChangeListener)this.sceneWindowListener);
        }
    }

    private void onDisplayChanged(Display display) {
        this.display = display;
        this.widget.displayId(display.id());
        this.notifyBoundsUpdated();
    }

    @Override
    public void enableDragAndDrop() {
    }

    @Override
    public void disableDragAndDrop() {
    }

    private void reFocusNativeWindow() {
        Preconditions.checkState((boolean)Environment.isWindows());
        if (this.window != null) {
            this.window.focusNatively();
        }
    }

    private class SceneBasedPositionListener
    implements ChangeListener<Transform> {
        private SceneBasedPositionListener() {
        }

        public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
            if (WindowedWidget.this.getScene() == null || this.isDetachedFromScene()) {
                return;
            }
            if (WindowedWidget.this.getScene().getWindow() == null) {
                return;
            }
            Point2D parentPosition = WindowedWidget.this.getParent().localToScreen(0.0, 0.0);
            if (Double.isNaN(parentPosition.getX()) || Double.isNaN(parentPosition.getY())) {
                return;
            }
            WindowedWidget.this.notifyBoundsUpdated();
        }

        private boolean isDetachedFromScene() {
            Parent view = WindowedWidget.this.getParent();
            return view == null || view.getParent() == null;
        }
    }

    private class SceneChangeListener
    implements ChangeListener<Scene> {
        private SceneChangeListener() {
        }

        public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
            Platform.runLater(() -> this.setScene(newValue));
        }

        private void setScene(Scene newScene) {
            if (WindowedWidget.this.scene != null) {
                if (newScene == null && Environment.isWindows() && WindowedWidget.this.isFocused()) {
                    WindowedWidget.this.reFocusNativeWindow();
                }
                WindowedWidget.this.parentTabTracker.stop();
                WindowedWidget.this.removeSceneListeners();
                WindowedWidget.this.setWindow(null);
            }
            WindowedWidget.this.scene = newScene;
            if (WindowedWidget.this.scene != null) {
                WindowedWidget.this.parentTabTracker.start();
                WindowedWidget.this.addSceneListeners();
                WindowedWidget.this.setWindow(WindowedWidget.this.scene.getWindow());
            }
        }
    }

    private class WindowShowingListener
    implements ChangeListener<Boolean> {
        private WindowShowingListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                WindowedWidget.this.show();
            } else {
                WindowedWidget.this.hide();
                WindowedWidget.this.detach();
            }
        }
    }

    private class SceneWindowListener
    implements ChangeListener<Window> {
        private SceneWindowListener() {
        }

        public void changed(ObservableValue<? extends Window> observable, Window oldValue, Window newValue) {
            WindowedWidget.this.setWindow(newValue);
        }
    }

    private class SizeChangedListener
    implements ChangeListener<Number> {
        private SizeChangedListener() {
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }

    private class FocusListener
    implements ChangeListener<Boolean> {
        private FocusListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            WindowedWidget.this.setFocus(newValue);
        }
    }

    private class WindowIconifiedListener
    implements ChangeListener<Boolean> {
        private boolean wasAttachedAtMinimize;

        private WindowIconifiedListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean wasIconified, Boolean isIconified) {
            if (isIconified.booleanValue()) {
                boolean bl = this.wasAttachedAtMinimize = WindowedWidget.this.state == State.ATTACHED;
                if (this.wasAttachedAtMinimize) {
                    this.minimize();
                }
            } else if (this.wasAttachedAtMinimize) {
                this.restore();
            }
        }

        private void restore() {
            if (Environment.isLinux()) {
                WindowedWidget.this.show();
            }
            WindowedWidget.this.widget.restore();
        }

        private void minimize() {
            if (Environment.isLinux()) {
                WindowedWidget.this.hide();
            }
            WindowedWidget.this.widget.minimize();
        }
    }

    private class WindowLocationListener
    implements ChangeListener<Number> {
        private WindowLocationListener() {
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }

    private class GlobalFocusOwnerListener
    implements ChangeListener<Node> {
        private GlobalFocusOwnerListener() {
        }

        public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
            if (oldValue instanceof WindowedWidget && !(newValue instanceof WindowedWidget)) {
                Scene scene;
                if (Environment.isWindows() && (scene = WindowedWidget.this.getScene()) != null && scene.getWindow().isFocused()) {
                    WindowedWidget.this.reFocusNativeWindow();
                }
                if (Environment.isLinux() && (scene = WindowedWidget.this.getScene()) != null && scene.getWindow().isFocused()) {
                    scene.getWindow().requestFocus();
                }
            }
        }
    }

    private static enum State {
        ATTACHED,
        DETACHED;

    }
}

