/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.BitmapTimeoutException;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.BrowserSettings;
import com.teamdev.jxbrowser.browser.CloseOptions;
import com.teamdev.jxbrowser.browser.SavePageType;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.event.BrowserEvent;
import com.teamdev.jxbrowser.browser.internal.BrowserRpcConfig;
import com.teamdev.jxbrowser.browser.internal.BrowserSettingsImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.DragAndDrop;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserStub;
import com.teamdev.jxbrowser.browser.internal.rpc.GetBitmapError;
import com.teamdev.jxbrowser.browser.internal.rpc.GetBitmapResult;
import com.teamdev.jxbrowser.browser.internal.rpc.ReplaceMisspelledWordRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.SavePage;
import com.teamdev.jxbrowser.browser.internal.rpc.Size;
import com.teamdev.jxbrowser.browser.internal.rpc.TargetFrame;
import com.teamdev.jxbrowser.browser.internal.rpc.UserAgent;
import com.teamdev.jxbrowser.browser.internal.rpc.WebPageStub;
import com.teamdev.jxbrowser.capture.CaptureSession;
import com.teamdev.jxbrowser.capture.internal.CaptureSessions;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.devtools.DevTools;
import com.teamdev.jxbrowser.devtools.internal.DevToolsImpl;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.Frames;
import com.teamdev.jxbrowser.frame.internal.rpc.FramesStub;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.FolderPath;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.FrameIdList;
import com.teamdev.jxbrowser.internal.rpc.LocalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.UniversalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.media.Audio;
import com.teamdev.jxbrowser.media.internal.AudioImpl;
import com.teamdev.jxbrowser.navigation.Navigation;
import com.teamdev.jxbrowser.navigation.internal.NavigationImpl;
import com.teamdev.jxbrowser.os.Display;
import com.teamdev.jxbrowser.print.internal.rpc.PrintFrameRequest;
import com.teamdev.jxbrowser.print.internal.rpc.PrintFrameResponse;
import com.teamdev.jxbrowser.print.internal.rpc.PrintRequestResult;
import com.teamdev.jxbrowser.print.internal.rpc.PrintServiceStub;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.search.TextFinder;
import com.teamdev.jxbrowser.search.internal.TextFinderImpl;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.zoom.Zoom;
import com.teamdev.jxbrowser.zoom.internal.ZoomImpl;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;

public final class BrowserImpl
extends CloseableImpl
implements Browser {
    private static final IdMap<BrowserId, BrowserImpl> browsers = new IdMap();
    private final BrowserId id;
    private final Frames frames;
    private final EngineImpl engine;
    private final ProfileImpl profile;
    private final BrowserWidget widget;
    private final CaptureSessions captureSessions;
    private final Lazy<ZoomImpl> zoom;
    private final Lazy<AudioImpl> audio;
    private final Lazy<DevToolsImpl> devTools;
    private final Lazy<DragAndDrop> dragAndDrop;
    private final Lazy<NavigationImpl> navigation;
    private final Lazy<TextFinderImpl> textFinder;
    private final Lazy<BrowserSettingsImpl> settings;
    private final UniversalServiceConnection rpc;
    private final LocalServiceConnection closeHelper;

    public static Optional<BrowserImpl> findImpl(BrowserId id) {
        Preconditions.checkNotNull(id);
        return browsers.find(id);
    }

    public static Optional<Browser> find(BrowserId id) {
        Preconditions.checkNotNull(id);
        return BrowserImpl.findImpl(id).map(br -> br);
    }

    public static BrowserImpl of(BrowserId id) {
        Preconditions.checkNotNull(id);
        return BrowserImpl.findImpl(id).orElseThrow(IllegalStateException::new);
    }

    public BrowserImpl(Connection connection, ProfileImpl profile, BrowserId id) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(profile);
        this.id = Preconditions.checkNotNull(id);
        this.profile = profile;
        this.engine = profile.engine();
        this.zoom = new Lazy<ZoomImpl>(() -> new ZoomImpl(this));
        this.audio = new Lazy<AudioImpl>(() -> new AudioImpl(this));
        this.devTools = new Lazy<DevToolsImpl>(() -> new DevToolsImpl(this));
        this.navigation = new Lazy<NavigationImpl>(() -> new NavigationImpl(this));
        this.textFinder = new Lazy<TextFinderImpl>(() -> new TextFinderImpl(this));
        this.settings = new Lazy<BrowserSettingsImpl>(() -> new BrowserSettingsImpl(this));
        this.dragAndDrop = new Lazy<DragAndDrop>(() -> new DragAndDrop(this));
        this.widget = new BrowserWidget(this);
        this.frames = new Frames(this);
        this.rpc = BrowserRpcConfig.create(this, connection);
        this.captureSessions = new CaptureSessions(this);
        this.closeHelper = new LocalServiceConnection(BrowserClosed.class);
        browsers.put(id, this);
        profile.register(this);
    }

    public BrowserId id() {
        return this.id;
    }

    public BrowserWidget widget() {
        return this.widget;
    }

    public CaptureSessions contentCaptureSessions() {
        return this.captureSessions;
    }

    public Connection connection() {
        return this.rpc.connection();
    }

    ServiceConnectionImpl<FramesStub> framesStub() {
        return this.frames.rpc();
    }

    @Override
    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public Optional<Frame> mainFrame() {
        this.checkNotClosed();
        return FrameImpl.find((FrameId)this.rpc.invoke(this.browserStub()::getMainFrame, this.id));
    }

    public BrowserStub browserStub() {
        return this.rpc.stub(BrowserStub.class);
    }

    @Override
    public Optional<Frame> focusedFrame() {
        this.checkNotClosed();
        FrameId id = (FrameId)this.rpc.invoke(this.browserStub()::getFocusedFrame, this.id);
        return FrameImpl.find(id);
    }

    @Override
    public List<CaptureSession> captureSessions() {
        this.checkNotClosed();
        return this.captureSessions.list();
    }

    @Override
    public List<Frame> frames() {
        this.checkNotClosed();
        return ((FrameIdList)this.rpc.invoke(this.browserStub()::getAllFrames, this.id)).getFrameIdList().stream().map(FrameImpl::of).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Bitmap bitmap() {
        this.checkNotClosed();
        GetBitmapResult result = (GetBitmapResult)this.rpc.invoke(this.browserStub()::getBitmap, this.id);
        if (result.getError() == GetBitmapError.TIMEOUT) {
            throw new BitmapTimeoutException();
        }
        return result.getBitmap();
    }

    @Override
    public Bitmap favicon() {
        this.checkNotClosed();
        return (Bitmap)this.rpc.invoke(this.browserStub()::getFavicon, this.id);
    }

    public void viewSource(FrameId frameId) {
        Preconditions.checkNotNull(frameId);
        this.checkNotClosed();
        TargetFrame request = TargetFrame.newBuilder().setBrowserId(this.id).setTargetFrameId(frameId).build();
        this.rpc.invoke(this.browserStub()::viewFrameSource, request);
    }

    @Override
    public TextFinder textFinder() {
        return this.textFinder.get();
    }

    @Override
    public Zoom zoom() {
        return this.zoom.get();
    }

    @Override
    public Audio audio() {
        return this.audio.get();
    }

    @Override
    public Navigation navigation() {
        return this.navigation.get();
    }

    @Override
    public BrowserSettings settings() {
        return this.settings.get();
    }

    @Override
    public DevTools devTools() {
        return this.devTools.get();
    }

    @Override
    public void replaceMisspelledWord(String word) {
        StringPreconditions.checkNotNullEmptyOrBlank(word);
        this.checkNotClosed();
        ReplaceMisspelledWordRequest request = ReplaceMisspelledWordRequest.newBuilder().setBrowserId(this.id).setReplacementWord(word).build();
        this.rpc.invoke(this.browserStub()::replaceMisspelledWord, request);
    }

    @Override
    public boolean saveWebPage(Path filePath, Path resourcesDir, SavePageType saveType) {
        Preconditions.checkNotNull(filePath);
        Preconditions.checkNotNull(resourcesDir);
        Preconditions.checkNotNull(saveType);
        this.checkNotClosed();
        SavePage request = SavePage.newBuilder().setBrowserId(this.id).setTargetFilePath(FilePath.newBuilder().setValue(filePath.toAbsolutePath().toString()).build()).setTargetFolderPath(FolderPath.newBuilder().setValue(resourcesDir.toAbsolutePath().toString()).build()).setType(saveType).build();
        return ((BoolValue)this.rpc.invoke(this.pageStub()::save, request)).getValue();
    }

    private WebPageStub pageStub() {
        return this.rpc.stub(WebPageStub.class);
    }

    @Override
    public String url() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.pageStub()::getUrl, this.id)).getValue();
    }

    @Override
    public String title() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.pageStub()::getTitle, this.id)).getValue();
    }

    @Override
    public String userAgent() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.browserStub()::getUserAgent, this.id)).getValue();
    }

    @Override
    public void userAgent(String userAgent) {
        StringPreconditions.checkNotNullEmptyOrBlank(userAgent);
        this.checkNotClosed();
        UserAgent request = UserAgent.newBuilder().setBrowserId(this.id).setUserAgent(userAgent).build();
        this.rpc.invoke(this.browserStub()::setUserAgent, request);
    }

    @Override
    public void focus() {
        this.checkNotClosed();
        this.widget.focus();
    }

    @Override
    public void unfocus() {
        this.checkNotClosed();
        this.widget.unfocus();
    }

    @Override
    public void resize(com.teamdev.jxbrowser.ui.Size size) {
        Preconditions.checkNotNull(size);
        Preconditions.checkArgument(!size.isEmpty());
        this.checkNotClosed();
        Size request = Size.newBuilder().setBrowserId(this.id).setSize(Wrappers.unwrap(size, com.teamdev.jxbrowser.ui.internal.rpc.Size.class)).build();
        this.rpc.invoke(this.browserStub()::setSize, request);
    }

    @Override
    public void resize(int width, int height) {
        Preconditions.checkArgument(width > 0 && height > 0);
        this.resize(com.teamdev.jxbrowser.ui.Size.of(width, height));
    }

    @Override
    public com.teamdev.jxbrowser.ui.Size size() {
        this.checkNotClosed();
        return (com.teamdev.jxbrowser.ui.Size)this.rpc.invoke(this.browserStub()::getSize, this.id);
    }

    @Override
    public Display display() {
        this.checkNotClosed();
        return (Display)this.rpc.invoke(this.browserStub()::getDisplay, this.id);
    }

    public Optional<String> remoteDebuggingUrl() {
        String url = ((StringValue)this.rpc.invoke(this.browserStub()::getRemoteDebuggingUrl, this.id)).getValue();
        return Optional.ofNullable(url.isEmpty() ? null : url);
    }

    public void showDevTools() {
        this.checkNotClosed();
        this.rpc.invoke(this.browserStub()::openDevToolsWindow, this.id);
    }

    public void hideDevTools() {
        this.checkNotClosed();
        this.rpc.invoke(this.browserStub()::closeDevToolsWindow, this.id);
    }

    @Override
    public void dispatch(KeyPressed event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(KeyReleased event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(KeyTyped event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MousePressed event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MouseReleased event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MouseEntered event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MouseExited event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MouseDragged event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MouseMoved event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    @Override
    public void dispatch(MouseWheel event) {
        this.checkNotClosed();
        this.widget.dispatch(event);
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop.get();
    }

    public void print(FrameId frameId) {
        this.checkNotClosed();
        PrintFrameRequest request = PrintFrameRequest.newBuilder().setBrowserId(this.id).setFrameId(frameId).build();
        PrintRequestResult result = ((PrintFrameResponse)this.rpc.invoke(this.rpc.stub(PrintServiceStub.class)::printFrame, request)).getResult();
        if (result == PrintRequestResult.FRAME_NOT_FOUND || result == PrintRequestResult.RENDER_PROCESS_NOT_FOUND) {
            throw new IllegalStateException("The frame is closed.");
        }
    }

    @Override
    public void close() {
        this.close(CloseOptions.newBuilder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close(CloseOptions options) {
        Preconditions.checkNotNull(options);
        if (this.isClosed()) {
            return;
        }
        Logger.debug("Closing browser...");
        if (!this.rpc.isClosed()) {
            CountDownLatch latch = new CountDownLatch(1);
            SubscriptionImpl subscription = this.closeHelper.on(BrowserClosed.class, (T event) -> latch.countDown());
            try {
                if (!this.tryToClose(options)) return;
                latch.await();
                Logger.debug("Closing browser... [OK]");
                return;
            }
            catch (InterruptedException ex) {
                Logger.warn("Browser closing has been interrupted.", ex);
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                subscription.unsubscribe();
            }
        } else {
            this.cleanup();
        }
    }

    private boolean tryToClose(CloseOptions options) {
        com.teamdev.jxbrowser.browser.internal.rpc.CloseOptions extendedOptions = ((com.teamdev.jxbrowser.browser.internal.rpc.CloseOptions)options).toBuilder().setBrowserId(this.id).build();
        return ((BoolValue)this.rpc.invoke(this.browserStub()::close, extendedOptions)).getValue();
    }

    public synchronized void cleanup() {
        Logger.debug("Releasing browser...");
        this.rpc.dispatch(() -> this);
        this.frames.close();
        this.widget.close();
        this.captureSessions.close();
        BrowserImpl.closeIfNecessary(this.zoom);
        BrowserImpl.closeIfNecessary(this.audio);
        BrowserImpl.closeIfNecessary(this.settings);
        BrowserImpl.closeIfNecessary(this.navigation);
        BrowserImpl.closeIfNecessary(this.textFinder);
        BrowserImpl.closeIfNecessary(this.dragAndDrop);
        super.close();
        this.profile.unregister(this);
        this.rpc.dispatch(BrowserClosed.newBuilder().setBrowserId(this.id).build());
        this.rpc.close();
        browsers.remove(this.id);
        this.closeHelper.dispatch(BrowserClosed.newBuilder().setBrowserId(this.id).build());
        this.closeHelper.close();
        Logger.debug("Releasing browser... [OK]");
    }

    public <E extends BrowserEvent> void notifyObservers(E event) {
        Preconditions.checkNotNull(event);
        this.rpc.dispatch(event);
    }

    public <E extends BrowserEvent> void notifyObserversAsync(E event) {
        Preconditions.checkNotNull(event);
        this.rpc.connection().rpcThread().submit(() -> this.notifyObservers(event));
    }

    public <E extends BrowserEvent> void notifyObserversAsync(E event, Runnable onCompleted) {
        Preconditions.checkNotNull(event);
        Preconditions.checkNotNull(onCompleted);
        this.rpc.connection().rpcThread().submit(() -> {
            try {
                this.notifyObservers(event);
            }
            finally {
                onCompleted.run();
            }
        });
    }

    @Override
    public <E extends BrowserEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public <C extends BrowserCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((BrowserCallback)this.rpc.set(callbackClass, callback));
    }

    public <T extends Message> void setCallbackInterceptor(Class<T> requestClass, Interceptor<T> interceptor) {
        this.rpc.setCallbackInterceptor(requestClass, interceptor);
    }

    @Override
    public <C extends BrowserCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends BrowserCallback> C remove(Class<C> callbackClass) {
        return (C)((BrowserCallback)this.rpc.remove(callbackClass));
    }

    static final class ClosingHandler
    implements Interceptor<BrowserClosed> {
        private final BrowserImpl browser;

        ClosingHandler(BrowserImpl browser) {
            this.browser = browser;
        }

        @Override
        public Interceptor.Action intercept(BrowserClosed data) {
            this.browser.cleanup();
            return Interceptor.Action.CANCEL;
        }
    }
}

