/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cache.internal;

import com.teamdev.jxbrowser.cache.HttpAuthCache;
import com.teamdev.jxbrowser.cache.internal.rpc.HttpAuthCacheStub;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;

public final class HttpAuthCacheImpl
extends CloseableImpl
implements HttpAuthCache {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<HttpAuthCacheStub> rpc;

    public HttpAuthCacheImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<HttpAuthCacheStub>(engine.id(), engine.connection(), HttpAuthCacheStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::clear, this.profile.id());
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

