/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ScaleFactor;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;

public final class Display {
    private static final String FAKE_DISPLAY_ID = "FakeDisplay";
    private static final double DEFAULT_SCALE_FACTOR = 1.0;
    private static Display primaryDisplay = null;
    private final String displayId;
    private final double scaleFactor;

    public static Display primaryDisplay() {
        if (primaryDisplay == null) {
            if (Environment.isLinux()) {
                primaryDisplay = Display.newInstance(FAKE_DISPLAY_ID, 1.0);
            } else {
                ToolkitLibrary library = ToolkitLibrary.instance();
                String displayId = library.getPrimaryDisplayId();
                double scaleFactor = library.getScaleFactorForDisplay(displayId);
                primaryDisplay = Display.newInstance(displayId, scaleFactor);
            }
        }
        return primaryDisplay;
    }

    private Display(String displayId, double scaleFactor) {
        this.displayId = displayId;
        this.scaleFactor = scaleFactor;
    }

    public static Display newInstance(String displayId, double scaleFactor) {
        if (Environment.isLinux()) {
            scaleFactor = ScaleFactor.getForcedJavaScaling();
        }
        return new Display(displayId, scaleFactor);
    }

    public String id() {
        return this.displayId;
    }

    public double scaleFactor() {
        return this.scaleFactor;
    }
}

