/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.os.Environment;
import java.util.List;

public final class ScaleFactor {
    private static final String SWING_SCALE_PROPERTY = "sun.java2d.uiScale";
    private static final String JAVAFX_SCALE_PROPERTY = "glass.gtk.uiScale";
    private static final double DEFAULT_SCALE_FACTOR = 1.0;

    private ScaleFactor() {
    }

    static boolean isForcedByChromiumSwitch(List<String> switches) {
        String scaleFactorSwitch = ChromiumSwitches.SWITCH_PREFIX + "force-device-scale-factor" + "=";
        for (String switcher : switches) {
            if (!switcher.startsWith(scaleFactorSwitch)) continue;
            return true;
        }
        return false;
    }

    static Double getForcedJavaScaling() {
        Preconditions.checkState(Environment.isLinux());
        Double javaScaleFactor = ScaleFactor.getLinuxSystemScaling();
        if (SystemProperties.hasProperty(SWING_SCALE_PROPERTY)) {
            javaScaleFactor = Double.parseDouble(System.getProperty(SWING_SCALE_PROPERTY));
        }
        if (SystemProperties.hasProperty(JAVAFX_SCALE_PROPERTY)) {
            javaScaleFactor = Double.parseDouble(System.getProperty(JAVAFX_SCALE_PROPERTY));
        }
        return javaScaleFactor;
    }

    private static Double getLinuxSystemScaling() {
        String gdkScale = System.getenv("GDK_SCALE");
        if (gdkScale != null) {
            try {
                double gdkScaleValue = Double.parseDouble(gdkScale);
                if (Double.compare(gdkScaleValue, 1.0) >= 0) {
                    return gdkScaleValue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0;
    }
}

