/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.js.JsException;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.rpc.CallMethodRequest;
import com.teamdev.jxbrowser.js.internal.rpc.JsObjectStub;
import com.teamdev.jxbrowser.js.internal.rpc.JsProperty;
import com.teamdev.jxbrowser.js.internal.rpc.JsPropertyKey;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.PropertyNameList;
import com.teamdev.jxbrowser.js.internal.rpc.ReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class JsObjectImpl
extends CloseableImpl
implements JsObject {
    private final JsObjectId id;
    private final JsContext jsContext;
    private final ServiceConnectionImpl<JsObjectStub> rpc;

    public JsObjectImpl(JsContext jsContext, JsObjectId jsObjectId) {
        Preconditions.checkNotNull(jsContext);
        Preconditions.checkNotNull(jsObjectId);
        this.id = jsObjectId;
        this.jsContext = jsContext;
        this.rpc = new ServiceConnectionImpl<JsObjectStub>(jsObjectId, jsContext.connection(), JsObjectStub::new);
    }

    public final JsObjectId objectId() {
        return this.id;
    }

    public final JsContext jsContext() {
        return this.jsContext;
    }

    @Override
    public Frame frame() {
        return this.jsContext.frame();
    }

    @Override
    public final List<String> propertyNames() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((PropertyNameList)this.rpc.invoke(this.rpc.stub()::getPropertyNames, this.objectId())).getPropertyNameList());
    }

    @Override
    public final List<String> ownPropertyNames() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((PropertyNameList)this.rpc.invoke(this.rpc.stub()::getOwnPropertyNames, this.objectId())).getPropertyNameList());
    }

    @Override
    public final boolean hasProperty(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JsPropertyKey key = JsPropertyKey.newBuilder().setObjectId(this.objectId()).setName(name).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasProperty, key)).getValue();
    }

    @Override
    public final <T> Optional<T> property(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JavaValue value = this.getProperty(JsPropertyKey.newBuilder().setObjectId(this.objectId()).setName(name).build());
        return Optional.ofNullable(value.toReturnValue());
    }

    @Override
    public final boolean putProperty(String name, @Nullable Object value) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        return this.putProperty(JsPropertyKey.newBuilder().setName(name).build(), value);
    }

    final boolean putProperty(JsPropertyKey key, @Nullable Object value) {
        JsProperty property = JsProperty.newBuilder().setObjectId(this.objectId()).setKey(key).setValue(this.toJsValue(value)).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setProperty, property)).getValue();
    }

    final JavaValue getProperty(JsPropertyKey key) {
        com.teamdev.jxbrowser.js.internal.JsValue response = (com.teamdev.jxbrowser.js.internal.JsValue)this.rpc.invoke(this.rpc.stub()::getProperty, key);
        return JavaValue.from(response);
    }

    JsValue toJsValue(@Nullable Object object) {
        return com.teamdev.jxbrowser.js.internal.JsValue.from(this.jsContext, object).impl();
    }

    @Override
    public final boolean removeProperty(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JsPropertyKey key = JsPropertyKey.newBuilder().setObjectId(this.objectId()).setName(name).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::removeProperty, key)).getValue();
    }

    @Override
    public final <T> T call(String methodName, Object ... args) {
        JavaValue value = this.callMethod(methodName, args);
        return value.toReturnValue();
    }

    private JavaValue callMethod(String methodName, Object ... args) {
        StringPreconditions.checkNotNullEmptyOrBlank(methodName);
        this.checkNotClosed();
        ArrayList<JsValue> jsArgs = new ArrayList<JsValue>();
        for (Object arg : args) {
            jsArgs.add(this.toJsValue(arg));
        }
        CallMethodRequest request = CallMethodRequest.newBuilder().setObjectId(this.objectId()).setMethodName(methodName).addAllArgs(jsArgs).build();
        ReturnValue response = (ReturnValue)this.rpc.invoke(this.rpc.stub()::callMethod, request);
        if (response.getValueCase() == ReturnValue.ValueCase.JS_VALUE) {
            return JavaValue.from(response.getJsValue());
        }
        throw new JsException(response.getJsError().getMessage());
    }

    protected final FrameId frameId() {
        return this.jsContext.frame().id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsObjectImpl)) {
            return false;
        }
        JsObjectImpl jsObject = (JsObjectImpl)o;
        return Objects.equals(this.id, jsObject.id) && Objects.equals(this.jsContext, jsObject.jsContext);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jsContext);
    }
}

