/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.profile.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.ProfilePreferences;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfilePreferencesStub;
import com.teamdev.jxbrowser.profile.internal.rpc.SetAutofillEnabledRequest;
import com.teamdev.jxbrowser.profile.internal.rpc.SetCaretBrowsingEnabledRequest;

final class ProfilePreferencesImpl
extends CloseableImpl
implements ProfilePreferences {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<ProfilePreferencesStub> rpc;

    ProfilePreferencesImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.rpc = new ServiceConnectionImpl<ProfilePreferencesStub>(profile.id(), profile.engine().connection(), ProfilePreferencesStub::new);
    }

    @Override
    public boolean isAutofillEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAutofillEnabled, this.profile.id())).getValue();
    }

    @Override
    public void enableAutofill() {
        this.setAutofillEnabled(true);
    }

    @Override
    public void disableAutofill() {
        this.setAutofillEnabled(false);
    }

    @Override
    public boolean isCaretBrowsingEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isCaretBrowsingEnabled, this.profile.id())).getValue();
    }

    @Override
    public void enableCaretBrowsing() {
        this.setCaretBrowsingEnabled(true);
    }

    @Override
    public void disableCaretBrowsing() {
        this.setCaretBrowsingEnabled(false);
    }

    private void setAutofillEnabled(boolean isEnabled) {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setAutofillEnabled, this.setAutofillRequest(isEnabled));
    }

    private SetAutofillEnabledRequest setAutofillRequest(boolean isEnabled) {
        return SetAutofillEnabledRequest.newBuilder().setProfileId(this.profile.id()).setIsEnabled(isEnabled).build();
    }

    private void setCaretBrowsingEnabled(boolean isEnabled) {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setCaretBrowsingEnabled, this.setCaretBrowsingRequest(isEnabled));
    }

    private SetCaretBrowsingEnabledRequest setCaretBrowsingRequest(boolean isEnabled) {
        return SetCaretBrowsingEnabledRequest.newBuilder().setProfileId(this.profile.id()).setIsEnabled(isEnabled).build();
    }
}

