/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.platform;

import com.teamdev.jxbrowser.internal.reflect.Classes;
import com.teamdev.jxbrowser.internal.reflect.Fields;
import com.teamdev.jxbrowser.internal.reflect.ReflectionException;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkLibrary;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class GtkLibraryV3
extends GtkLibrary {
    GtkLibraryV3() {
    }

    @Override
    public long xWindow(Shell shell) {
        Method x11WindowGetter = this.drawingMethod("gdk_x11_window_get_xid");
        return this.get(x11WindowGetter, this.gdkWindow(shell));
    }

    @Override
    public long xDisplay(Shell shell) {
        Method gdkDisplayGetter = this.drawingMethod("gdk_window_get_display");
        Method xDisplayGetter = this.drawingMethod("gdk_x11_display_get_xdisplay");
        long display = this.get(gdkDisplayGetter, this.gdkWindow(shell));
        return this.get(xDisplayGetter, display);
    }

    @Override
    public long socketHandle(Composite composite) {
        if ((composite.getStyle() & 0x1000000) == 0) {
            throw new IllegalArgumentException("Only Composite with SWT.EMBEDDED has GtkSocket");
        }
        Field field = Fields.declaredField(Composite.class, (String)"socketHandle");
        return (Long)Fields.value((Object)composite, (Field)field);
    }

    private long gdkWindow(Shell shell) {
        Method gtkTopLevelGetter = this.toolkitMethod("gtk_widget_get_toplevel");
        Method gtkWindowGetter = this.toolkitMethod("gtk_widget_get_window");
        long topLevelWidget = this.get(gtkTopLevelGetter, shell);
        return this.get(gtkWindowGetter, topLevelWidget);
    }

    private long widget(Shell shell) {
        Field handleField = Fields.declaredField(Widget.class, (String)"handle");
        return (Long)Fields.value((Object)shell, (Field)handleField);
    }

    private Method drawingMethod(String methodName) {
        Class<?> gdk = this.gdk();
        return this.methodIn(gdk, methodName);
    }

    private Method toolkitMethod(String methodName) {
        Class<?> gtk = this.gtk();
        return this.methodIn(gtk, methodName);
    }

    private long get(Method method, Shell shell) {
        return this.get(method, this.widget(shell));
    }

    private Class<?> gtk() {
        try {
            return Classes.forName((String)"org.eclipse.swt.internal.gtk.GTK");
        }
        catch (ReflectionException e) {
            return Classes.forName((String)"org.eclipse.swt.internal.gtk3.GTK3");
        }
    }

    private Class<?> gdk() {
        return Classes.forName((String)"org.eclipse.swt.internal.gtk.GDK");
    }
}

