/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragGestureListener;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragImage;
import java.util.Optional;

final class BrowserDragContext {
    private final DragGestureListener dragGestureListener = new DragGestureListener();
    private CurrentDragOperation dragOperation;

    static BrowserDragContext newInstance() {
        return new BrowserDragContext();
    }

    private BrowserDragContext() {
    }

    void browserDragOperation(DropData dropData, DragImage dragImage) {
        Preconditions.checkNotNull((Object)dropData);
        Preconditions.checkNotNull((Object)dragImage);
        this.dragOperation = new CurrentDragOperation(dragImage, dropData);
    }

    Optional<CurrentDragOperation> browserDragOperation() {
        return Optional.ofNullable(this.dragOperation);
    }

    void resetBrowserDragOperation() {
        this.dragOperation = null;
    }

    DragGestureListener dragGestureListener() {
        return this.dragGestureListener;
    }

    static class CurrentDragOperation {
        private final DragImage dragImage;
        private final DropData dropData;

        private CurrentDragOperation(DragImage dragImage, DropData dropData) {
            this.dragImage = dragImage;
            this.dropData = dropData;
        }

        DragImage dragImage() {
            return this.dragImage;
        }

        DropData dropData() {
            return this.dropData;
        }
    }
}

