/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swing.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DefaultTransferHandler;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragGestureListener;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragLifecycleEvents;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragMouseEvents;
import com.teamdev.jxbrowser.view.swing.internal.dnd.MacOsCompatibility;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;

public class DragAndDropSupport {
    private final BrowserDragContext context = BrowserDragContext.newInstance();
    private final DragMouseEvents dragMouseEvents;
    private final DragLifecycleEvents dragLifecycleEvents;
    private final OffScreenRenderWidget component;
    private final DragGestureRecognizer dragGestureRecognizer;
    private State state;

    public static DragAndDropSupport newInstance(OffScreenRenderWidget component) {
        Preconditions.checkNotNull((Object)component);
        return new DragAndDropSupport(component);
    }

    private DragAndDropSupport(OffScreenRenderWidget component) {
        this.component = component;
        this.dragMouseEvents = DragMouseEvents.newInstance(component, this.context);
        this.dragLifecycleEvents = DragLifecycleEvents.newInstance(component, this.context);
        this.dragGestureRecognizer = this.createGestureRecognizer();
        component.setTransferHandler(new DefaultTransferHandler());
        this.state = State.DISABLED;
    }

    public void enable() {
        if (this.state == State.ENABLED) {
            return;
        }
        this.dragLifecycleEvents.startForwarding();
        this.dragMouseEvents.startForwarding();
        this.dragGestureRecognizer.setComponent(this.component);
        this.state = State.ENABLED;
    }

    public void disable() {
        if (this.state == State.DISABLED) {
            return;
        }
        this.dragMouseEvents.stopForwarding();
        this.dragLifecycleEvents.stopForwarding();
        this.dragGestureRecognizer.setComponent(null);
        this.state = State.DISABLED;
    }

    public boolean isBrowserDragHappening() {
        return this.context.browserDragOperation().isPresent();
    }

    private DragGestureRecognizer createGestureRecognizer() {
        int actionsMask = 0x40000003;
        DragSource dragSource = new DragSource();
        DragGestureListener listener = this.context.dragGestureListener();
        DragGestureRecognizer recognizer = dragSource.createDefaultDragGestureRecognizer(null, actionsMask, listener);
        return recognizer;
    }

    static {
        if (Environment.isMac()) {
            MacOsCompatibility.configureFlavorMap();
        }
        CustomDataSupport.configureFlavorMap();
    }

    private static enum State {
        ENABLED,
        DISABLED;

    }
}

