/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.deps.com.google.common.base.Converter;
import javax.annotation.ParametersAreNonnullByDefault;

final class DragOperations {
    private static final Converter<Integer, DragOperation> CONVERTER = new OperationConverter();

    private DragOperations() {
    }

    static int toDragOperationMask(int dragActionMask) {
        int result = 0;
        if ((dragActionMask & 1) == 1) {
            result |= 2;
        }
        if ((dragActionMask & 2) == 2) {
            result |= 0x10;
        }
        if ((dragActionMask & 0x40000000) == 0x40000000) {
            result |= 3;
        }
        return result;
    }

    static DragOperation convert(int dragAction) {
        return (DragOperation)CONVERTER.convert((Object)dragAction);
    }

    static int convert(DragOperation dragOperation) {
        return (Integer)CONVERTER.reverse().convert((Object)dragOperation);
    }

    @ParametersAreNonnullByDefault
    private static final class OperationConverter
    extends Converter<Integer, DragOperation> {
        private OperationConverter() {
        }

        protected DragOperation doForward(Integer dragAction) {
            if (dragAction == 1) {
                return DragOperation.OPERATION_COPY;
            }
            if (dragAction == 2) {
                return DragOperation.OPERATION_MOVE;
            }
            if (dragAction == 0x40000000) {
                return DragOperation.OPERATION_LINK;
            }
            return DragOperation.OPERATION_NONE;
        }

        protected Integer doBackward(DragOperation operation) {
            if (operation == DragOperation.OPERATION_NONE) {
                return 0;
            }
            if (operation == DragOperation.OPERATION_COPY) {
                return 1;
            }
            if (operation == DragOperation.OPERATION_MOVE) {
                return 2;
            }
            if (operation == DragOperation.OPERATION_LINK) {
                return 0x40000000;
            }
            return 1;
        }
    }
}

