/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.browser.internal.AccessibilityNode;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.MemoryId;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.GraphicsWebDialogView;
import com.teamdev.jxbrowser.view.swt.internal.MemoryImage;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import com.teamdev.jxbrowser.view.swt.internal.platform.HiDpi;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

final class GraphicsRenderWidget
extends OffScreenRenderWidget {
    private final MemoryImage memoryImage = new MemoryImage();
    private final AccessibilityNode accessibleWebView;
    private final AccessibilityNode accessibleWebDialog;

    GraphicsRenderWidget(BrowserView parent, BrowserWidget widget) {
        super(parent, widget);
        this.accessibleWebView = AccessibilityNode.create((BrowserWidget)widget);
        this.accessibleWebDialog = AccessibilityNode.create((BrowserWidget)widget);
        if (Environment.isLinux()) {
            this.addPaintListener(e -> {
                Transform swtTransform = new Transform(e.gc.getDevice());
                e.gc.getTransform(swtTransform);
                double scale = 1.0 / this.memoryImage.deviceScaleFactor();
                swtTransform.scale((float)scale, (float)scale);
                e.gc.setTransform(swtTransform);
                GraphicsRenderWidget graphicsRenderWidget = this;
                synchronized (graphicsRenderWidget) {
                    this.memoryImage.image().ifPresent(image -> e.gc.drawImage(image, 0, 0));
                }
                swtTransform.dispose();
                widget.onPainted();
            });
        }
        if (Environment.isWindows()) {
            this.addPaintListener(e -> {
                GraphicsRenderWidget graphicsRenderWidget = this;
                synchronized (graphicsRenderWidget) {
                    this.memoryImage.memoryId().ifPresent(memoryId -> {
                        this.drawImage((MemoryId)memoryId, this.memoryImage.width(), this.memoryImage.height(), this.memoryImage.deviceScaleFactor());
                        widget.onPainted();
                    });
                }
            });
        }
        BrowserImpl browser = widget.browser();
        widget.set(CreateWebDialogCallback.class, (BrowserWidgetCallback)((CreateWebDialogCallback)params -> {
            SafeExecutor.asyncExec((Widget)this, () -> {
                WebDialog webDialog = new WebDialog(browser, params.getWebDialogId());
                GraphicsWebDialogView webDialogView = new GraphicsWebDialogView(this, webDialog, (com.teamdev.jxbrowser.ui.Rect)params.getInitialBounds(), params.getScaleFactor());
                webDialog.on(DialogBoundsUpdated.class, e -> SafeExecutor.asyncExec((Widget)this, () -> webDialogView.moveToTopCenter((com.teamdev.jxbrowser.ui.Rect)e.getBounds(), e.getScaleFactor())));
                webDialog.on(DialogClosed.class, e -> SafeExecutor.asyncExec((Widget)this, () -> ((GraphicsWebDialogView)webDialogView).dispose()));
                webDialogView.redraw();
                long handle = webDialogView.nativeHandle();
                this.accessibleWebDialog.add(handle, handle);
            });
            return CreateWebDialog.Response.newBuilder().build();
        }));
        widget.set(PaintCallback.class, (BrowserWidgetCallback)new OnPaint());
    }

    @Override
    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        this.accessibleWebView.add(this.nativeHandle(), this.nativeHandle());
        super.showRenderWidget();
        this.redraw();
    }

    @Override
    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        this.accessibleWebView.remove();
        super.hideRenderWidget();
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }

    private void drawImage(MemoryId memoryId, int width, int height, double scaleFactor) {
        ToolkitLibrary library = ToolkitLibrary.instance();
        if (HiDpi.isPlatformDpiAware()) {
            library.drawImage(this.nativeHandle(), width, height, memoryId.getValue());
        } else {
            library.drawScaledImage(this.nativeHandle(), width, height, memoryId.getValue(), scaleFactor);
        }
    }

    @Override
    protected void close() {
        BrowserWidget widget = this.browserWidget();
        if (!widget.isClosed()) {
            widget.remove(PaintCallback.class);
            widget.remove(CreateWebDialogCallback.class);
        }
        super.close();
    }

    private void redrawIfShown() {
        if (this.isShown()) {
            this.redraw();
        }
    }

    private final class OnPaint
    implements PaintCallback {
        private OnPaint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Paint.Response on(Paint.Request params) {
            PaintRequest request = params.getPaintRequest();
            com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = request.getViewSize();
            Rect dirtyRect = request.getDirtyRect();
            if (!GraphicsRenderWidget.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                return Paint.Response.newBuilder().build();
            }
            MemoryId memoryId = request.getMemoryId();
            GraphicsRenderWidget graphicsRenderWidget = GraphicsRenderWidget.this;
            synchronized (graphicsRenderWidget) {
                GraphicsRenderWidget.this.memoryImage.updateMemoryId(memoryId);
                GraphicsRenderWidget.this.memoryImage.updateSize((Size)viewSize, request.getScaleFactor());
            }
            if (Environment.isWindows()) {
                GraphicsRenderWidget.this.drawImage(memoryId, viewSize.width(), viewSize.height(), request.getScaleFactor());
            } else if (Environment.isLinux()) {
                graphicsRenderWidget = GraphicsRenderWidget.this;
                synchronized (graphicsRenderWidget) {
                    GraphicsRenderWidget.this.memoryImage.updatePixels((com.teamdev.jxbrowser.ui.Rect)dirtyRect);
                    GraphicsRenderWidget.this.memoryImage.repaintImage((Composite)GraphicsRenderWidget.this, (Size)viewSize, (com.teamdev.jxbrowser.ui.Rect)dirtyRect, rect -> GraphicsRenderWidget.this.redrawIfShown());
                }
            }
            GraphicsRenderWidget.this.browserWidget().onPainted();
            return Paint.Response.newBuilder().build();
        }
    }
}

