/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dialog;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.ui.internal.Action;
import com.teamdev.jxbrowser.ui.internal.DefaultDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SwtDialog<D extends SwtDialog<D>>
extends DefaultDialog<D> {
    private final Shell owner;

    SwtDialog(SwtDialogBuilder<D, ?> builder) {
        super(builder);
        this.owner = ((SwtDialogBuilder)builder).owner.getShell();
    }

    protected abstract Composite createContents(Composite var1);

    public final void open() {
        Shell shell = new Shell(this.owner, 67680);
        shell.setText(this.title);
        shell.setLayout((Layout)new GridLayout());
        this.initContents(shell);
        this.initButtonPanel(shell);
        shell.addListener(21, e -> {
            if (!this.actionSelected) {
                this.defaultCallback.run();
            }
        });
        shell.pack();
        this.centerShell(shell);
        shell.open();
        Display display = this.owner.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void centerShell(Shell shell) {
        Rectangle parentSize = shell.getParent().getBounds();
        Rectangle shellSize = shell.getBounds();
        int x = (parentSize.width - shellSize.width) / 2 + parentSize.x;
        int y = (parentSize.height - shellSize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(x, y));
    }

    private void initContents(Shell shell) {
        Composite contents = this.createContents((Composite)shell);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        contents.setLayoutData((Object)data);
    }

    private void initButtonPanel(Shell shell) {
        Composite buttonPanel = new Composite((Composite)shell, 0);
        buttonPanel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        buttonPanel.setLayout((Layout)new RowLayout());
        for (Action action : this.actions) {
            Button button = new Button(buttonPanel, 8);
            button.setText(action.label());
            button.addListener(13, event -> {
                this.actionSelected = true;
                action.callback().accept((SwtDialog)this.self());
                shell.close();
            });
        }
    }

    final void putDisplayedMessage(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.message);
    }

    static abstract class SwtDialogBuilder<D extends SwtDialog<D>, B extends SwtDialogBuilder<D, B>>
    extends DefaultDialog.Builder<D, B> {
        private final Shell owner;

        SwtDialogBuilder(Shell owner, String message) {
            super(message);
            StringPreconditions.checkNotNullEmptyOrBlank((String)message);
            this.owner = (Shell)Preconditions.checkNotNull((Object)owner);
        }
    }
}

