/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.menu;

import com.teamdev.jxbrowser.browser.callback.internal.ShowSuggestionsCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.Suggestion;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.suggestions.SuggestionsPopupType;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swt.BrowserView;
import com.teamdev.jxbrowser.view.swt.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class SuggestionsPopup {
    private static final Map<BrowserId, SuggestionsPopup> OPEN_POPUPS = new ConcurrentHashMap<BrowserId, SuggestionsPopup>();
    private final ShowSuggestionsCallback.Params params;
    private final ShowSuggestionsCallback.Action action;
    private final BrowserId browserId;
    private final BrowserView parentBrowserView;
    private final CustomMouseListener customMouseListener;
    private Shell parentShell;
    private Shell suggestionsShell;
    private Table suggestionsTable;

    static Optional<SuggestionsPopup> fromBrowser(BrowserId id) {
        return Optional.ofNullable(OPEN_POPUPS.get(id));
    }

    public SuggestionsPopup(BrowserView parent, ShowSuggestionsCallback.Params params, ShowSuggestionsCallback.Action action) {
        this.parentBrowserView = parent;
        this.params = params;
        this.action = action;
        this.browserId = ((BrowserImpl)parent.getBrowser()).id();
        SuggestionsPopup.fromBrowser(this.browserId).ifPresent(SuggestionsPopup::hide);
        this.customMouseListener = new CustomMouseListener();
    }

    private void fillSuggestions(List<Suggestion> suggestions) {
        this.suggestionsTable.removeMouseListener((MouseListener)this.customMouseListener);
        for (Suggestion suggestion : suggestions) {
            TableItem suggestionItem = new TableItem(this.suggestionsTable, 0);
            String text = this.params.popupType() == SuggestionsPopupType.PASSWORDS ? String.format("%s  %s", suggestion.getValue(), suggestion.getHiddenPassword()) : (this.params.popupType() == SuggestionsPopupType.ADDRESSES ? String.format("%s  %s", suggestion.getValue(), suggestion.getAddressOrFullname()) : (this.params.popupType() == SuggestionsPopupType.CREDIT_CARDS ? String.format("%s  %s", suggestion.getValue(), suggestion.getCreditCardInfo()) : suggestion.getValue()));
            suggestionItem.setText(text);
        }
        this.customMouseListener.suggestions(suggestions);
        this.suggestionsTable.addMouseListener((MouseListener)this.customMouseListener);
    }

    public void show() {
        SafeExecutor.asyncExec((Widget)this.parentBrowserView, () -> {
            this.parentShell = this.parentBrowserView.getShell();
            this.suggestionsShell = new Shell(this.parentShell, 1);
            this.suggestionsTable = new Table((Composite)this.suggestionsShell, 8);
            this.temporarilyDisableFocusListener();
            org.eclipse.swt.graphics.Point parentLocation = this.parentBrowserView.toDisplay(0, 0);
            com.teamdev.jxbrowser.ui.internal.rpc.Point locationInBrowser = this.params.location();
            Point screenSpaceLocation = Point.of((int)(parentLocation.x + locationInBrowser.x()), (int)(parentLocation.y + locationInBrowser.y()));
            this.suggestionsShell.setLocation(screenSpaceLocation.x(), screenSpaceLocation.y());
            this.suggestionsShell.setLayout((Layout)new FillLayout());
            this.suggestionsShell.addDisposeListener(e -> {
                if (!this.action.isClosed()) {
                    this.action.cancel();
                }
                OPEN_POPUPS.remove(this.browserId);
            });
            this.fillSuggestions(this.params.suggestions());
            this.suggestionsTable.pack();
            this.suggestionsShell.pack();
            this.suggestionsShell.setVisible(true);
            OPEN_POPUPS.put(this.browserId, this);
        });
    }

    private void temporarilyDisableFocusListener() {
        boolean isOffscreen;
        boolean bl = isOffscreen = this.parentBrowserView.getBrowser().engine().options().renderingMode() == RenderingMode.OFF_SCREEN;
        if (Environment.isLinux() && isOffscreen) {
            final OffScreenRenderWidget offScreenRenderWidget = (OffScreenRenderWidget)this.parentBrowserView.getChildren()[0];
            OffScreenRenderWidget.FocusListener focusListener = offScreenRenderWidget.focusListener();
            offScreenRenderWidget.removeFocusListener((FocusListener)focusListener);
            this.suggestionsShell.addShellListener((ShellListener)new ShellAdapter((FocusListener)focusListener){
                final /* synthetic */ FocusListener val$focusListener;
                {
                    this.val$focusListener = focusListener;
                }

                public void shellActivated(ShellEvent e) {
                    offScreenRenderWidget.addFocusListener(this.val$focusListener);
                    offScreenRenderWidget.setFocus();
                }
            });
        }
    }

    void updateSuggestions(List<Suggestion> updatedSuggestions) {
        SafeExecutor.asyncExec((Widget)this.parentBrowserView, () -> {
            this.suggestionsTable.removeAll();
            this.fillSuggestions(updatedSuggestions);
            this.suggestionsShell.pack();
        });
    }

    void hide() {
        SafeExecutor.asyncExec((Widget)this.parentBrowserView, this::disposePopup);
    }

    private void disposePopup() {
        if (!this.suggestionsShell.isDisposed()) {
            this.suggestionsShell.dispose();
        }
    }

    private class CustomMouseListener
    extends MouseAdapter {
        private List<Suggestion> suggestions;

        private CustomMouseListener() {
        }

        private void suggestions(List<Suggestion> suggestions) {
            this.suggestions = suggestions;
        }

        public void mouseDown(MouseEvent e) {
            int index = SuggestionsPopup.this.suggestionsTable.getSelectionIndex();
            if (index != -1) {
                SuggestionsPopup.this.action.accept(this.suggestions.get(index));
            }
            SuggestionsPopup.this.disposePopup();
        }
    }
}

