/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateSurface;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import com.teamdev.jxbrowser.view.javafx.internal.IoSurfaceWebDialogView;
import com.teamdev.jxbrowser.view.javafx.internal.OffScreenRenderWidget;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public final class IoSurfaceRenderWidget
extends OffScreenRenderWidget {
    private final NsView nsView;

    public IoSurfaceRenderWidget(BrowserWidget widget) {
        super(widget);
        this.nsView = new NsView(widget);
        this.widget().set(CreateWebDialogCallback.class, (BrowserWidgetCallback)((CreateWebDialogCallback)params -> {
            WebDialog webDialog = new WebDialog(widget.browser(), params.getWebDialogId());
            IoSurfaceWebDialogView webDialogView = new IoSurfaceWebDialogView(this.widget(), (Node)this, webDialog);
            Platform.runLater(() -> {
                if (this.window != null) {
                    long nsViewId = this.window.nativeId();
                    webDialogView.show(nsViewId, (Rect)params.getInitialBounds());
                }
            });
            return CreateWebDialog.Response.newBuilder().build();
        }));
        this.widget().set(UpdateSurfaceCallback.class, (BrowserWidgetCallback)((UpdateSurfaceCallback)params -> {
            this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor());
            return UpdateSurface.Response.newBuilder().build();
        }));
        this.widget().set(UpdateLayerCallback.class, (BrowserWidgetCallback)((UpdateLayerCallback)params -> {
            this.nsView.setNsViewLayer(params.getContextId(), params.getScaleFactor());
            return UpdateLayer.Response.newBuilder().build();
        }));
    }

    @Override
    protected void close() {
        this.widget().remove(CreateWebDialogCallback.class);
        this.nsView.close();
        super.close();
    }

    @Override
    protected void show() {
        if (this.isBrowserWidgetShown()) {
            return;
        }
        super.show();
        if (this.window != null) {
            Rectangle2D bounds = this.getBounds();
            Rect rect = Rect.of((int)((int)bounds.getMinX()), (int)((int)bounds.getMinY()), (int)((int)bounds.getWidth()), (int)((int)bounds.getHeight()));
            this.nsView.show(this.window.nativeId(), rect);
        }
        this.widget().attach(0L);
    }

    @Override
    protected void hide() {
        if (!this.isBrowserWidgetShown()) {
            return;
        }
        this.nsView.hide();
        super.hide();
    }

    @Override
    protected boolean alwaysTrackSize() {
        return true;
    }

    @Override
    protected void notifyBoundsUpdated() {
        super.notifyBoundsUpdated();
        Rectangle2D bounds = this.getBounds();
        this.nsView.updateBounds(Rect.of((int)((int)bounds.getMinX()), (int)((int)bounds.getMinY()), (int)((int)bounds.getWidth()), (int)((int)bounds.getHeight())));
    }

    private Rectangle2D getBounds() {
        Window window;
        Scene scene = this.getScene();
        if (scene != null && (window = scene.getWindow()) != null) {
            Point2D widgetLocation = this.localToScreen(0.0, 0.0);
            double sceneX = scene.getX();
            double sceneY = scene.getY();
            double windowX = window.getX();
            double windowY = window.getY();
            Point inWindow = Point.of((int)((int)Math.round(widgetLocation.getX() - windowX - sceneX)), (int)((int)Math.round(widgetLocation.getY() - windowY - sceneY)));
            inWindow = this.adjustForFxPanel(window, inWindow);
            return new Rectangle2D((double)inWindow.x(), (double)inWindow.y(), this.getWidth(), this.getHeight());
        }
        return new Rectangle2D(0.0, 0.0, 0.0, 0.0);
    }
}

