/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.annotations.VisibleForTesting;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.base.Splitter;

public final class JavaFxVersion {
    public static final int JAVAFX_14 = 14;
    @VisibleForTesting
    static final String JAVAFX_VERSION = "javafx.version";
    private static final int VERSION_PARTS = 3;

    public static boolean isOlderThan(int version) {
        Preconditions.checkArgument((version >= 2 ? 1 : 0) != 0);
        return JavaFxVersion.major() < version;
    }

    private JavaFxVersion() {
    }

    private static int major() {
        try {
            String wholeVersion = System.getProperty(JAVAFX_VERSION);
            String majorVersion = (String)Splitter.on((String)".").limit(3).splitToList((CharSequence)wholeVersion).get(0);
            return Integer.parseInt(majorVersion);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Couldn't detect JavaFX version", e);
        }
    }
}

