/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window.reflection;

import com.teamdev.jxbrowser.internal.reflect.AccessibleObjects;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.internal.window.reflection.TkStage;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.stage.Window;

public final class PlatformWindow {
    private static final String GLASS_WINDOW_FQN = "com.sun.glass.ui.Window";
    private static final String GLASS_VIEW_FQN = "com.sun.glass.ui.View";
    private final Object platformWindow;

    public static Optional<PlatformWindow> from(Window window) {
        TkStage tkStage = TkStage.from(window);
        if (Environment.isJre8()) {
            Optional<Object> platformWindow = tkStage.getPlatformWindow();
            return platformWindow.map(PlatformWindow::new);
        }
        long rawHandle = tkStage.getRawHandle();
        return PlatformWindow.findByRawHandle(rawHandle);
    }

    private PlatformWindow(Object platformWindow) {
        this.platformWindow = platformWindow;
    }

    public Optional<Long> getNativeHandle() {
        Object nativeHandle = this.getNativeHandleReflective();
        return Optional.ofNullable((Long)nativeHandle);
    }

    public Optional<Long> getNativeWindow() {
        Object nativeWindow = this.getNativeWindowReflective();
        return Optional.ofNullable((Long)nativeWindow);
    }

    public Optional<Long> getNativeView() {
        Object nativeView = this.getNativeViewReflective();
        return Optional.ofNullable((Long)nativeView);
    }

    private static List<PlatformWindow> getWindows() {
        Method getWindows = Methods.getMethod((String)GLASS_WINDOW_FQN, (String)"getWindows", (Class[])new Class[0]);
        List objects = (List)Methods.invokeStatic((Method)getWindows, (Object[])new Object[0]);
        return objects.stream().map(PlatformWindow::new).collect(Collectors.toList());
    }

    private static Optional<PlatformWindow> findByRawHandle(long rawHandle) {
        List<PlatformWindow> windows = PlatformWindow.getWindows();
        for (PlatformWindow platformWindow : windows) {
            long platformRawHandle = platformWindow.getRawHandle();
            if (platformRawHandle != rawHandle) continue;
            return Optional.of(platformWindow);
        }
        return Optional.empty();
    }

    private long getRawHandle() {
        Method getPlatformRawHandle = Methods.getMethod((String)GLASS_WINDOW_FQN, (String)"getRawHandle", (Class[])new Class[0]);
        return (Long)Methods.invoke((Object)this.platformWindow, (Method)getPlatformRawHandle, (Object[])new Object[0]);
    }

    private Object getNativeHandleReflective() {
        Method getNativeHandle = Methods.getMethod((String)GLASS_WINDOW_FQN, (String)"getNativeHandle", (Class[])new Class[0]);
        AccessibleObjects.makeAccessible((AccessibleObject)getNativeHandle);
        return Methods.invoke((Object)this.platformWindow, (Method)getNativeHandle, (Object[])new Object[0]);
    }

    private Object getNativeWindowReflective() {
        Method getNativeWindow = Methods.getMethod((String)GLASS_WINDOW_FQN, (String)"getNativeWindow", (Class[])new Class[0]);
        AccessibleObjects.makeAccessible((AccessibleObject)getNativeWindow);
        return Methods.invoke((Object)this.platformWindow, (Method)getNativeWindow, (Object[])new Object[0]);
    }

    private Object getNativeViewReflective() {
        Method getView = Methods.getMethod((String)GLASS_WINDOW_FQN, (String)"getView", (Class[])new Class[0]);
        AccessibleObjects.makeAccessible((AccessibleObject)getView);
        Object view = Methods.invoke((Object)this.platformWindow, (Method)getView, (Object[])new Object[0]);
        Method getNativeView = Methods.getMethod((String)GLASS_VIEW_FQN, (String)"getNativeView", (Class[])new Class[0]);
        return Methods.invoke((Object)view, (Method)getNativeView, (Object[])new Object[0]);
    }
}

