/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TakeFocusCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.TakeFocus;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.internal.BrowserComponent;
import com.teamdev.jxbrowser.view.swing.internal.ComponentLocator;
import com.teamdev.jxbrowser.view.swing.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.swing.internal.HiDpi;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DefaultTransferHandler;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;

public final class WindowedWidget
extends JComponent
implements BrowserComponent {
    private static final Set<WindowedWidget> windowedWidgets = Collections.synchronizedSet(new HashSet());
    private final BrowserWidget widget;
    private final ResizeListener resizeListener;
    private final DisplayWatcher displayWatcher;
    private final HierarchyListener hierarchyListener;
    private final HierarchyBoundsListener hierarchyBoundsListener;
    private final ComponentListener windowMovedListener;
    private final WindowListener windowIconifiedListener;
    private final ComponentFocusListener componentFocusListener;
    private final AWTEventListener globalFocusListener;
    private final AWTEventListener globalFocusListenerWin;
    private final Subscription browserClosed;
    private boolean closed;
    private Display display;
    private Subscription focusGained;

    public WindowedWidget(BrowserWidget widget) {
        Preconditions.checkNotNull((Object)widget);
        this.widget = widget;
        this.resizeListener = new ResizeListener();
        this.hierarchyListener = new HierarchyListenerImpl();
        this.hierarchyBoundsListener = new HierarchyBoundsListenerImpl();
        this.windowMovedListener = new WindowMovedListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
        this.componentFocusListener = new ComponentFocusListener();
        this.globalFocusListener = new GlobalFocusListener();
        this.globalFocusListenerWin = new GlobalFocusListenerWin();
        this.display = Display.primaryDisplay();
        this.displayWatcher = DisplayWatcher.newInstance(this::onDisplayChanged, widget.browser().engine().options().switches());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this.globalFocusListener, 4L);
        if (Environment.isWindows()) {
            toolkit.addAWTEventListener(this.globalFocusListenerWin, 524288L);
        }
        this.setFocusable(true);
        this.browserClosed = widget.browser().on(BrowserClosed.class, event -> SwingUtilities.invokeLater(this::close));
        if (Environment.isLinux()) {
            this.setTransferHandler(new DefaultTransferHandler());
        }
    }

    private void close() {
        this.removeComponentListeners();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.globalFocusListener);
        if (Environment.isWindows()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.globalFocusListenerWin);
        }
        windowedWidgets.remove(this);
        this.browserClosed.unsubscribe();
        this.closed = true;
    }

    private boolean isClosed() {
        return this.closed;
    }

    private void focus(FocusRequest.Cause cause) {
        if (!this.widget.isClosed() && this.isEnabled()) {
            this.widget.focus(cause);
        }
    }

    private void unfocus() {
        if (!this.widget.isClosed() && this.isEnabled()) {
            this.widget.unfocus();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setShowing(visible);
    }

    private void setShowing(boolean showing) {
        if (showing) {
            this.attachWidget();
        } else {
            if (!this.widget.isClosed()) {
                this.widget.hide();
            }
            windowedWidgets.remove(this);
        }
    }

    private void addComponentListeners() {
        this.addHierarchyListener(this.hierarchyListener);
        this.addHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.addComponentListener(this.resizeListener);
        this.addFocusListener(this.componentFocusListener);
        this.addWindowListeners();
        this.focusGained = this.widget.browser().on(FocusGained.class, event -> {
            if (Environment.isWindows()) {
                Set<WindowedWidget> set = windowedWidgets;
                synchronized (set) {
                    for (WindowedWidget widget : windowedWidgets) {
                        if (widget.equals(this)) continue;
                        widget.unfocus();
                    }
                }
            }
            SwingUtilities.invokeLater(() -> {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (focusManager.getFocusOwner() != null) {
                    focusManager.clearGlobalFocusOwner();
                }
                WindowedWidget.setMostRecentFocusOwner(this);
                MenuSelectionManager.defaultManager().clearSelectedPath();
            });
        });
        this.widget.set(TakeFocusCallback.class, (BrowserWidgetCallback)((TakeFocusCallback)params -> {
            SwingUtilities.invokeLater(() -> {
                Window window;
                if (Environment.isLinux() && (window = SwingUtilities.getWindowAncestor(this)) != null) {
                    this.componentFocusListener.ignoreNextFocusEvent();
                    window.toFront();
                }
                if (params.getFocusNextComponent()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this);
                }
            });
            return TakeFocus.Response.newBuilder().setTake(Protobuf.empty()).build();
        }));
    }

    private void removeComponentListeners() {
        if (this.focusGained != null) {
            this.focusGained.unsubscribe();
        }
        this.widget.remove(TakeFocusCallback.class);
        this.removeComponentListener(this.resizeListener);
        this.removeHierarchyListener(this.hierarchyListener);
        this.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.removeFocusListener(this.componentFocusListener);
        this.removeWindowListeners();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.isClosed()) {
            this.addComponentListeners();
            this.setShowing(this.isShowing());
        }
    }

    @Override
    public void removeNotify() {
        if (!this.isClosed()) {
            this.setShowing(false);
            this.removeComponentListeners();
        }
        super.removeNotify();
    }

    private void addWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addComponentListener(this.windowMovedListener);
            window.addWindowListener(this.windowIconifiedListener);
            this.displayWatcher.attach(window);
        }
    }

    private void removeWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeComponentListener(this.windowMovedListener);
            window.removeWindowListener(this.windowIconifiedListener);
            this.displayWatcher.detach();
        }
    }

    private static void setMostRecentFocusOwner(Component focusOwner) {
        Component component;
        for (component = focusOwner; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        Window window = (Window)component;
        try {
            AWTAccessor.getKeyboardFocusManagerAccessor().setMostRecentFocusOwner(window, focusOwner);
        }
        catch (IllegalAccessError e) {
            if (!Environment.isJre8()) {
                Logger.warn((String)"The focus traversal may malfunction. Export `java.desktop/sun.awt` to ALL-UNNAMED or `jxbrowser.swing` module");
                Logger.warn((String)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    private void notifyBoundsUpdated() {
        if (this.isShowing() && !this.widget.isClosed()) {
            Rectangle bounds = this.getBounds();
            Point locationOnScreen = this.getLocationOnScreen();
            if (WindowedWidget.isInvalid(bounds.getSize())) {
                return;
            }
            bounds.setLocation(ComponentLocator.locationInWindow(this));
            Rect boundsInWindow = Geometry.newRect((double)bounds.x, (double)bounds.y, (double)bounds.width, (double)bounds.height);
            Rect boundsInScreen = Geometry.newRect((double)locationOnScreen.x, (double)locationOnScreen.y, (double)bounds.width, (double)bounds.height);
            if (!HiDpi.isPlatformDpiAware()) {
                boundsInWindow = Geometry.scaleDown((Rect)boundsInWindow, (double)this.display.scaleFactor());
                boundsInScreen = Geometry.scaleDown((Rect)boundsInScreen, (double)this.display.scaleFactor());
            }
            this.widget.bounds(boundsInWindow, boundsInScreen);
        }
    }

    private static boolean isInvalid(Dimension size) {
        Preconditions.checkNotNull((Object)size);
        return size.width < 0 || size.height < 0;
    }

    private void attachWidget() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            long windowHandle = AwtHelperLibrary.instance().getWindowHandle(window);
            Size initialSize = Size.of((int)this.getWidth(), (int)this.getHeight());
            if (!HiDpi.isPlatformDpiAware()) {
                initialSize = Geometry.scaleDown((Size)initialSize, (double)this.display.scaleFactor());
            }
            this.widget.attach(windowHandle, this::onAttached, this::onAttachFailed, initialSize);
        }
    }

    private void onAttached() {
        SwingUtilities.invokeLater(() -> {
            if (this.isShowing()) {
                this.widget.show();
                this.notifyBoundsUpdated();
                windowedWidgets.add(this);
            }
        });
    }

    private void onAttachFailed() {
        SwingUtilities.invokeLater(this::close);
    }

    private void onDisplayChanged(Display display) {
        this.display = display;
        this.widget.displayId(display.id());
        this.notifyBoundsUpdated();
    }

    @Override
    public void enableDragAndDrop() {
    }

    @Override
    public void disableDragAndDrop() {
    }

    private boolean isAttached() {
        return windowedWidgets.contains(this);
    }

    private final class HierarchyBoundsListenerImpl
    implements HierarchyBoundsListener {
        private HierarchyBoundsListenerImpl() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            WindowedWidget.this.notifyBoundsUpdated();
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }

    private class HierarchyListenerImpl
    implements HierarchyListener {
        private HierarchyListenerImpl() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 1L || e.getChangeFlags() == 4L) {
                Component topLevelContainer = e.getChanged();
                WindowedWidget.this.setShowing(topLevelContainer.isShowing() && WindowedWidget.this.isShowing());
            }
        }
    }

    private class GlobalFocusListenerWin
    implements AWTEventListener {
        private GlobalFocusListenerWin() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            Window topLevelWindow;
            Window window;
            boolean isFocusLost = event.getID() == 208;
            Object source = event.getSource();
            if (source instanceof Window && isFocusLost && (window = (Window)source).equals(topLevelWindow = SwingUtilities.getWindowAncestor(WindowedWidget.this))) {
                WindowedWidget.this.unfocus();
            }
        }
    }

    private class GlobalFocusListener
    implements AWTEventListener {
        private GlobalFocusListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            boolean isFocusGained = event.getID() == 1004;
            boolean isHeavyweightWidget = WindowedWidget.this.equals(event.getSource());
            if (isFocusGained && !isHeavyweightWidget) {
                WindowedWidget.this.unfocus();
            }
        }
    }

    private class WindowIconifiedListener
    extends WindowAdapter {
        private boolean wasAttachedAtMinimize;

        private WindowIconifiedListener() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.wasAttachedAtMinimize = WindowedWidget.this.isAttached();
            if (this.wasAttachedAtMinimize) {
                this.minimize();
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            if (this.wasAttachedAtMinimize) {
                this.restore();
            }
        }

        private void restore() {
            if (Environment.isLinux()) {
                WindowedWidget.this.setShowing(true);
            }
            WindowedWidget.this.widget.restore();
        }

        private void minimize() {
            if (Environment.isLinux()) {
                WindowedWidget.this.setShowing(false);
            }
            WindowedWidget.this.widget.minimize();
        }
    }

    private class WindowMovedListener
    extends ComponentAdapter {
        private WindowMovedListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }

    private class ComponentFocusListener
    extends FocusAdapter {
        private boolean ignoreNextFocusEvent;

        private ComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.ignoreNextFocusEvent) {
                this.ignoreNextFocusEvent = false;
                return;
            }
            WindowedWidget.this.focus(Platform.instance().focusGainedCause(e));
        }

        void ignoreNextFocusEvent() {
            this.ignoreNextFocusEvent = true;
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            WindowedWidget.this.notifyBoundsUpdated();
        }
    }
}

